/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.security;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class MD {
    /*
     * Enabled aggressive exception aggregation
     */
    public static BigInteger checksum(Object obj) {
        if (obj == null) {
            return BigInteger.ZERO;
        }
        Class<?> clz = obj.getClass();
        if (!Serializable.class.isAssignableFrom(clz)) {
            String tostring = obj.toString();
            if (tostring.contains(clz.getName()) && tostring.contains("@")) {
                return BigInteger.valueOf(obj.hashCode());
            }
            obj = tostring;
        }
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            BigInteger bigInteger;
            try (ObjectOutputStream oos = new ObjectOutputStream(baos);){
                oos.writeObject(obj);
                MessageDigest m = MessageDigest.getInstance("MD5");
                m.update(baos.toByteArray());
                bigInteger = new BigInteger(1, m.digest());
            }
            return bigInteger;
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to write to object output stream ERROR:" + e.getMessage(), e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Unable to get message digest MD5 ERROR:" + e.getMessage());
        }
    }
}

