/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.security.data;

import java.io.Serializable;
import nyla.solutions.core.security.data.Permission;

public class SecurityPermissionContains
implements Permission,
Serializable {
    private static final long serialVersionUID = 7042157206407846236L;
    private final String text;

    public SecurityPermissionContains(String text) {
        if (text == null || text.length() == 0) {
            throw new IllegalArgumentException("text is required");
        }
        this.text = text;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.text == null ? 0 : this.text.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SecurityPermissionContains other = (SecurityPermissionContains)obj;
        return !(this.text == null ? other.text != null : !this.text.equals(other.text));
    }

    @Override
    public boolean isAuthorized(Permission permission) {
        if (permission == null) {
            return false;
        }
        String txtPermission = permission.getText();
        if (txtPermission == null || txtPermission.length() == 0) {
            return false;
        }
        return this.text.contains(txtPermission) || txtPermission.contains(this.text);
    }

    @Override
    public String getText() {
        return this.text;
    }
}

