/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import nyla.solutions.core.util.Debugger;
import nyla.solutions.core.util.JavaBean;

public class BeanComparator
implements Comparator<Object>,
Serializable {
    private boolean descending = false;
    private String propertyName = "";
    static final long serialVersionUID = BeanComparator.class.getName().hashCode();

    public BeanComparator(String aPropertyName, boolean aDescending) {
        this.setPropertyName(aPropertyName);
        this.descending = aDescending;
    }

    public boolean isDescending() {
        return this.descending;
    }

    public final void setDescending(boolean descending) {
        this.descending = descending;
    }

    public BeanComparator(String aPropertyName) {
        this(aPropertyName, false);
    }

    @Override
    public int compare(Object aBean1, Object aBean2) {
        int results = this.internalCompare(aBean1, aBean2);
        if (this.descending) {
            return results * -1;
        }
        return results;
    }

    private int internalCompare(Object aBean1, Object aBean2) {
        if (aBean1 == aBean2) {
            return 0;
        }
        if (this.propertyName != null && this.propertyName.length() != 0) {
            try {
                Comparable e = (Comparable)JavaBean.getProperty(aBean1, this.propertyName);
                Comparable comparable2 = (Comparable)JavaBean.getProperty(aBean2, this.propertyName);
                if (e == comparable2) {
                    return 0;
                }
                if (e != null && comparable2 != null) {
                    return e.compareTo(comparable2);
                }
                if (e != null && comparable2 == null) {
                    return 1;
                }
                return -1;
            }
            catch (Exception arg4) {
                throw new RuntimeException(Debugger.stackTrace(arg4));
            }
        }
        Debugger.printWarn(this, "Bean property not set, the list will not be sorted");
        return 0;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String aProperyName) {
        this.propertyName = aProperyName;
    }

    public List<?> sort(Collection<?> aCollection) {
        ArrayList list = null;
        list = aCollection instanceof List ? (ArrayList)aCollection : new ArrayList(aCollection);
        Collections.sort(list, this);
        return list;
    }
}

