/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.util;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.stream.Collectors;
import nyla.solutions.core.data.AbstractAuditable;
import nyla.solutions.core.data.Auditable;
import nyla.solutions.core.data.Copier;
import nyla.solutions.core.data.Criteria;
import nyla.solutions.core.data.Mappable;
import nyla.solutions.core.data.NumberedProperty;
import nyla.solutions.core.data.PrimaryKey;
import nyla.solutions.core.data.Property;
import nyla.solutions.core.exception.RequiredException;
import nyla.solutions.core.exception.SystemException;
import nyla.solutions.core.operations.logging.Log;
import nyla.solutions.core.patterns.expression.BooleanExpression;
import nyla.solutions.core.patterns.iteration.PageCriteria;
import nyla.solutions.core.patterns.iteration.Paging;
import nyla.solutions.core.patterns.iteration.PagingCollection;
import nyla.solutions.core.util.BeanComparator;
import nyla.solutions.core.util.Config;
import nyla.solutions.core.util.Debugger;
import nyla.solutions.core.util.JavaBean;
import nyla.solutions.core.util.Text;

public final class Organizer {
    private static Log logger = Debugger.getLog(Organizer.class);

    private Organizer() {
    }

    public static <T> T first(T[] array) {
        if (array == null || array.length < 1) {
            return null;
        }
        return array[0];
    }

    public static <T> T[] add(T input, T[] array) {
        ArrayList<T> list = new ArrayList<T>(array.length + 1);
        list.addAll(Arrays.asList(array));
        list.add(input);
        return list.toArray(array);
    }

    public static <T> void flatten(Collection<?> input, Collection<T> flattenOutput) {
        if (input == null || input.isEmpty() || flattenOutput == null) {
            return;
        }
        for (Object inputObj : input) {
            if (inputObj == null) continue;
            if (inputObj instanceof Collection) {
                Organizer.flatten((Collection)inputObj, flattenOutput);
                continue;
            }
            flattenOutput.add(inputObj);
        }
    }

    public static <T> Paging<T> flattenPaging(Collection<Paging<T>> collectionOfPaging) {
        if (collectionOfPaging == null || collectionOfPaging.isEmpty()) {
            return null;
        }
        PageCriteria pageCriteria = null;
        Paging<T> firstPaging = collectionOfPaging.iterator().next();
        if (firstPaging != null) {
            pageCriteria = firstPaging.getPageCriteria();
        }
        return Organizer.flattenPaging(collectionOfPaging, pageCriteria, null, null);
    }

    public static <T> Paging<T> flattenPaging(Collection<Paging<T>> collectionOfPaging, Comparator<T> sorter, BooleanExpression<T> filter) {
        if (collectionOfPaging == null || collectionOfPaging.isEmpty()) {
            return null;
        }
        PageCriteria pageCriteria = collectionOfPaging.iterator().next().getPageCriteria();
        return Organizer.flattenPaging(collectionOfPaging, pageCriteria, sorter, filter);
    }

    public static <T> Paging<T> flattenPaging(Collection<?> collectionOfPaging, PageCriteria pageCriteria, Comparator<T> sorter, BooleanExpression<T> filter) {
        if (collectionOfPaging == null || collectionOfPaging.isEmpty()) {
            return null;
        }
        Paging<Object> pagingResults = null;
        if (sorter != null) {
            TreeSet<T> treeSet = new TreeSet<T>(sorter);
            pagingResults = new PagingCollection<T>(treeSet, pageCriteria);
        }
        Paging paging = null;
        for (Object item : collectionOfPaging) {
            if (item instanceof Paging) {
                paging = (Paging)item;
                if (pagingResults != null) {
                    Organizer.addAll(pagingResults, paging, filter);
                    continue;
                }
                pagingResults = paging;
                continue;
            }
            if (item == null) continue;
            if (pagingResults == null) {
                if (sorter != null) {
                    TreeSet<T> treeSet = new TreeSet<T>(sorter);
                    pagingResults = new PagingCollection<T>(treeSet, pageCriteria);
                } else {
                    pagingResults = new PagingCollection(new ArrayList(), pageCriteria);
                }
            }
            pagingResults.add(item);
        }
        return pagingResults;
    }

    public static <T> void addAll(Collection<T> pagingResults, Collection<T> paging, BooleanExpression<T> filter) {
        if (pagingResults == null || paging == null) {
            return;
        }
        if (filter != null) {
            for (T obj : paging) {
                if (!((Boolean)filter.apply((Object)obj)).booleanValue()) continue;
                pagingResults.add(obj);
            }
        } else {
            for (T obj : paging) {
                pagingResults.add(obj);
            }
        }
    }

    public static <T> List<T> toList(T ... args) {
        if (args == null || args.length == 0) {
            return null;
        }
        ArrayList<T> list = new ArrayList<T>(args.length);
        for (T t : args) {
            list.add(t);
        }
        return list;
    }

    public static <T> Set<T> toSet(T ... args) {
        if (args == null || args.length == 0) {
            return null;
        }
        HashSet set = new HashSet(args.length);
        Organizer.fill(set, args);
        return set;
    }

    public static <T> void fill(Collection<T> collection, T ... args) {
        if (collection == null || args == null) {
            return;
        }
        for (T t : args) {
            collection.add(t);
        }
    }

    public static <T> List<Collection<T>> toPages(Collection<T> collection, int pageSize) {
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        int collectionSize = collection.size();
        if (pageSize <= 0 || collectionSize <= pageSize) {
            return Collections.singletonList(collection);
        }
        int initialSize = collectionSize / pageSize;
        ArrayList<Collection<T>> list = new ArrayList<Collection<T>>(initialSize);
        ArrayList<T> current = new ArrayList<T>();
        for (T object : collection) {
            current.add(object);
            if (current.size() < pageSize) continue;
            current.trimToSize();
            list.add(current);
            current = new ArrayList();
        }
        if (!current.isEmpty()) {
            list.add(current);
        }
        return list;
    }

    public static <K, V> List<Collection<K>> toKeyPages(Collection<Map.Entry<K, V>> mapEntries, int pageSize) {
        if (mapEntries == null || mapEntries.isEmpty()) {
            return null;
        }
        int collectionSize = mapEntries.size();
        if (pageSize <= 0 || collectionSize <= pageSize) {
            ArrayList<K> list = new ArrayList<K>(mapEntries.size());
            for (Map.Entry<K, V> entry : mapEntries) {
                if (entry == null) continue;
                list.add(entry.getKey());
            }
            if (list.isEmpty()) {
                return null;
            }
            return Collections.singletonList(list);
        }
        int initialSize = collectionSize / pageSize;
        ArrayList<Collection<K>> list = new ArrayList<Collection<K>>(initialSize);
        ArrayList<K> current = new ArrayList<K>();
        for (Map.Entry<K, V> entry : mapEntries) {
            current.add(entry.getKey());
            if (current.size() < pageSize) continue;
            current.trimToSize();
            list.add(current);
            current = new ArrayList();
        }
        if (!current.isEmpty()) {
            list.add(current);
        }
        return list;
    }

    public static Object findMapValueByKey(Object key, Map<?, ?> map, Object defaultValue) {
        if (key == null || map == null) {
            return defaultValue;
        }
        Object value = map.get(key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public static boolean isStringIn(String text, String[] list) {
        if (text == null) {
            return false;
        }
        for (int i = 0; i < list.length; ++i) {
            if (!text.equals(list[i])) continue;
            return true;
        }
        return false;
    }

    public static Object findByTextIgnoreCase(Collection<?> aCollection, String aText) {
        if (aText == null) {
            throw new RequiredException("aName in Organizer.findIgnoreCase");
        }
        if (aCollection == null) {
            throw new RequiredException("aCollection in Organizer.findIgnoreCase");
        }
        Object element2 = null;
        for (Object element2 : aCollection) {
            if (element2 == null || !aText.equalsIgnoreCase(element2.toString())) continue;
            return element2;
        }
        throw new SystemException("Text=" + aText + " in collection  " + aCollection);
    }

    public static void addAll(Collection<Object> list, Object[] objects) {
        list.addAll(Arrays.asList(objects));
    }

    static <K, V> boolean doesListContainData(Object[] objects, Map<K, V> aData) throws Exception {
        if (objects == null || objects.length == 0) {
            return false;
        }
        Map<Object, Object> objectMap = null;
        for (int i = 0; i < objects.length; ++i) {
            objectMap = JavaBean.toMap(objects[i]);
            if (!Organizer.doesMapContainData(objectMap, aData)) continue;
            return true;
        }
        return false;
    }

    public static boolean doesMapContainData(Map<Object, Object> aMap, Map<Object, Object> aData) {
        Object testMapKey = null;
        for (Map.Entry<Object, Object> entry : aData.entrySet()) {
            testMapKey = entry.getKey();
            if (String.valueOf(aMap.get(testMapKey)).equals(String.valueOf(entry.getValue()))) continue;
            return false;
        }
        return true;
    }

    public static <T> T[] copy(Object[] objs) {
        if (objs == null) {
            return null;
        }
        Object[] results = new Object[objs.length];
        System.arraycopy(objs, 0, results, 0, results.length);
        return results;
    }

    public static void copyToArray(Collection<Object> collection, Object[] objects) {
        System.arraycopy(collection.toArray(), 0, objects, 0, objects.length);
    }

    public static <K, V> void addMappableCopiesToMap(Collection<Mappable<K, V>> aMappables, Map<K, V> aMap) {
        if (aMappables == null || aMap == null) {
            return;
        }
        Mappable<K, V> mappable2 = null;
        Copier previous = null;
        for (Mappable<K, V> mappable2 : aMappables) {
            previous = (Copier)aMap.get(mappable2.getKey());
            if (previous != null) {
                previous.copy((Copier)((Object)mappable2));
                continue;
            }
            aMap.put(mappable2.getKey(), mappable2.getValue());
        }
    }

    public static <T, K> Collection<T> findMapValuesByKey(Collection<K> aKeys, Map<K, T> aMap) {
        if (aKeys == null || aMap == null) {
            return null;
        }
        Object key2 = null;
        ArrayList<T> results = new ArrayList<T>(aMap.size());
        for (Object key2 : aKeys) {
            results.add(aMap.get(key2));
        }
        results.trimToSize();
        return results;
    }

    public static <T> void addAll(Collection<T> aFrom, Collection<T> aTo) {
        if (aFrom == null || aTo == null) {
            return;
        }
        Object object2 = null;
        for (Object object2 : aFrom) {
            if (object2 == null) continue;
            aTo.add(object2);
        }
    }

    public static boolean isEmpty(Collection<?> aCollection) {
        return aCollection == null || aCollection.isEmpty();
    }

    public static boolean isEmpty(Object[] objects) {
        return objects == null || objects.length == 0;
    }

    public static boolean isIntegerIn(Integer aInt, Integer[] aIntegers) {
        if (aIntegers == null || aInt == null) {
            return false;
        }
        for (int i = 0; i < aIntegers.length; ++i) {
            if (!aInt.equals(aIntegers[i])) continue;
            return true;
        }
        return false;
    }

    public static Map<String, Criteria> constructCriteriaMap(Collection<Criteria> aCriterias) {
        if (aCriterias == null) {
            return null;
        }
        HashMap<String, Criteria> map = new HashMap<String, Criteria>(aCriterias.size());
        Criteria criteria2 = null;
        for (Criteria criteria2 : aCriterias) {
            map.put(criteria2.getId(), criteria2);
        }
        return map;
    }

    public static Map<Integer, PrimaryKey> constructPrimaryKeyMap(Collection<PrimaryKey> aPrimaryKeys) {
        if (aPrimaryKeys == null) {
            return null;
        }
        HashMap<Integer, PrimaryKey> map = new HashMap<Integer, PrimaryKey>(aPrimaryKeys.size());
        PrimaryKey primaryKey2 = null;
        for (PrimaryKey primaryKey2 : aPrimaryKeys) {
            map.put(primaryKey2.getPrimaryKey(), primaryKey2);
        }
        return map;
    }

    public static Property findPropertyByName(String aName, Collection<Property> aProperties) {
        if (aName == null) {
            throw new IllegalArgumentException("aName required in Organizer.findPropertyByName");
        }
        if (aProperties == null) {
            throw new IllegalArgumentException("aProperties required in Organizer.findPropertyByName");
        }
        Property property2 = null;
        for (Property property2 : aProperties) {
            if (!aName.equals(property2.getName())) continue;
            return property2;
        }
        return null;
    }

    public static <K> void makeCopies(Map<K, Copier> aFrom, Map<K, Copier> aTo) {
        Organizer.makeAuditableCopies(aFrom, aTo, null);
    }

    public static void makeCopies(Collection<Copier> aFrom, Collection<Copier> aTo) {
        if (aFrom == null || aTo == null) {
            return;
        }
        ArrayList<Copier> fromList = new ArrayList<Copier>(aFrom);
        ArrayList<Copier> toList = new ArrayList<Copier>(aTo);
        Collections.sort(fromList);
        Collections.sort(toList);
        Copier from = null;
        Copier to = null;
        Iterator toIter = toList.iterator();
        Iterator i = fromList.iterator();
        while (i.hasNext() && toIter.hasNext()) {
            from = (Copier)i.next();
            to = (Copier)toIter.next();
            to.copy(from);
        }
    }

    public static <K> void makeAuditableCopies(Map<K, Copier> aFormMap, Map<K, Copier> aToMap, Auditable aAuditable) {
        if (aFormMap == null || aToMap == null) {
            return;
        }
        Object fromKey = null;
        Copier to = null;
        Copier from = null;
        for (Map.Entry<K, Copier> entry : aFormMap.entrySet()) {
            fromKey = entry.getKey();
            if (aToMap.keySet().contains(fromKey)) {
                to = aToMap.get(fromKey);
                to.copy(entry.getValue());
                if (aAuditable == null || !(to instanceof Auditable)) continue;
                AbstractAuditable.copy(aAuditable, (Auditable)((Object)to));
                continue;
            }
            from = aFormMap.get(fromKey);
            if (aAuditable != null && from instanceof Auditable) {
                AbstractAuditable.copy(aAuditable, (Auditable)((Object)from));
            }
            aToMap.put(fromKey, from);
        }
    }

    public static <T> Collection<T> sortByJavaBeanProperty(String aProperyName, Collection<T> aCollection) {
        return Organizer.sortByJavaBeanProperty(aProperyName, aCollection, false);
    }

    public static <K, V> Map<K, V> sortByValue(Map<K, V> map, BeanComparator beanComparator) {
        return map.entrySet().stream().sorted(Map.Entry.comparingByValue(beanComparator)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
    }

    public static <T> Collection<T> sortByJavaBeanProperty(String aProperyName, Collection<T> aCollection, boolean aDescending) {
        if (aCollection == null) {
            return new ArrayList();
        }
        if (aProperyName == null) {
            throw new IllegalArgumentException("aProperyName required in Organizer");
        }
        BeanComparator bc = new BeanComparator(aProperyName, aDescending);
        return bc.sort(aCollection);
    }

    public static <T> Set<T> constructSortedSetForProperty(Collection<T> aCollection, String aPropertyName) throws Exception {
        if (aCollection == null || aCollection.isEmpty()) {
            return null;
        }
        TreeSet set = new TreeSet();
        Object bean2 = null;
        for (Object bean2 : aCollection) {
            set.add(JavaBean.getProperty(bean2, aPropertyName));
        }
        return set;
    }

    public static Collection<Object> filterByJavaBeanProperty(List<Object> aList, String propertyName, Comparable<Object> aValue) {
        logger.debug("In Organizer filtering: " + propertyName + " for value: " + aValue);
        try {
            if (aList == null) {
                throw new IllegalArgumentException("aCollection required in filterByJavaBeanProperty");
            }
            ArrayList<Object> filteredList = new ArrayList<Object>(aList.size());
            Object bean2 = null;
            Object beanPropertyValue = null;
            for (Object bean2 : aList) {
                beanPropertyValue = JavaBean.getProperty(bean2, propertyName);
                logger.debug("Got propertyValue: " + beanPropertyValue + " for propertyName: " + propertyName);
                if (aValue.compareTo(beanPropertyValue) != 0) continue;
                filteredList.add(bean2);
                logger.debug("Organizer added bean");
            }
            filteredList.trimToSize();
            return filteredList;
        }
        catch (Exception e) {
            throw new SystemException(e);
        }
    }

    public static Collection<Object> filterByJavaBeanDateProperty(List<Object> list, String propertyName, Comparable<Object> startComparable, Comparable<Object> endComparable) {
        logger.debug("In Organizer filtering: " + propertyName + " for date value between : " + startComparable + " and " + endComparable);
        try {
            if (list == null) {
                throw new IllegalArgumentException("aCollection required in filterByJavaBeanProperty");
            }
            ArrayList<Object> filteredList = new ArrayList<Object>(list.size());
            Object bean = null;
            Object beanPropertyValue = null;
            Iterator<Object> i = list.iterator();
            while (i.hasNext()) {
                try {
                    bean = i.next();
                    beanPropertyValue = JavaBean.getProperty(bean, propertyName);
                    SimpleDateFormat format = new SimpleDateFormat(Config.getProperty("document.date.format"));
                    Date propDate = format.parse(beanPropertyValue.toString());
                    Date aDate = format.parse(startComparable.toString());
                    Date bDate = format.parse(endComparable.toString());
                    if (!propDate.after(aDate) || !propDate.before(bDate)) continue;
                    filteredList.add(bean);
                }
                catch (Exception e) {
                    logger.debug("error occured : " + e);
                }
            }
            filteredList.trimToSize();
            return filteredList;
        }
        catch (Exception e) {
            throw new SystemException(e);
        }
    }

    public static Collection<Object> filterByJavaBeanPageProperty(ArrayList<Object> aList, String aPropertyName, int fromIndex, int toIndex) {
        logger.debug("In Organizer filtering: " + aPropertyName);
        try {
            if (aList == null) {
                throw new IllegalArgumentException("aCollection required in filterByJavaBeanProperty");
            }
            ArrayList<Object> filteredList = new ArrayList<Object>(aList.size());
            Object bean = null;
            Object beanPropertyValue = null;
            Iterator<Object> i = aList.iterator();
            while (i.hasNext()) {
                try {
                    bean = i.next();
                    beanPropertyValue = JavaBean.getProperty(bean, aPropertyName);
                    int beanPropIntVal = Integer.parseInt(beanPropertyValue.toString());
                    if (fromIndex > beanPropIntVal || beanPropIntVal > toIndex) continue;
                    filteredList.add(bean);
                }
                catch (Exception e) {
                    logger.debug("error occured : " + e);
                }
            }
            filteredList.trimToSize();
            return filteredList;
        }
        catch (Exception e) {
            throw new SystemException(e);
        }
    }

    public static Map<Integer, NumberedProperty> constructNumberedPropertyMap(Collection<NumberedProperty> aNumberedProperties) {
        if (aNumberedProperties == null) {
            throw new IllegalArgumentException("aNumberedProperties required in Organizer");
        }
        HashMap<Integer, NumberedProperty> map = new HashMap<Integer, NumberedProperty>(aNumberedProperties.size());
        NumberedProperty numberedProperty2 = null;
        for (NumberedProperty numberedProperty2 : aNumberedProperties) {
            map.put(numberedProperty2.getNumber(), numberedProperty2);
        }
        return map;
    }

    public static Map<String, Property> constructPropertyMap(Collection<Property> aProperties) {
        if (aProperties == null) {
            throw new IllegalArgumentException("aProperties required in Organizer");
        }
        HashMap<String, Property> map = new HashMap<String, Property>(aProperties.size());
        Property property2 = null;
        for (Property property2 : aProperties) {
            map.put(property2.getName(), property2);
        }
        return map;
    }

    public static <K, V> Map<K, V> toMap(Collection<Mappable<K, V>> aMappables) {
        if (aMappables == null) {
            throw new IllegalArgumentException("aMappables required in Organizer");
        }
        HashMap map = new HashMap(aMappables.size());
        Mappable<K, V> mappable2 = null;
        for (Mappable<K, V> mappable2 : aMappables) {
            map.put(mappable2.getKey(), mappable2.getValue());
        }
        return map;
    }

    public static <K, V> Map<K, V> toMap(Mappable<K, V>[] aMappables) {
        if (aMappables == null) {
            throw new IllegalArgumentException("aMappables required in Organizer");
        }
        HashMap map = new HashMap(aMappables.length);
        Mappable<K, V> mappable = null;
        for (int i = 0; i < aMappables.length; ++i) {
            mappable = aMappables[i];
            map.put(mappable.getKey(), mappable.getValue());
        }
        return map;
    }

    public static Object[] toArray(Object obj) {
        if (obj instanceof Object[]) {
            return (Object[])obj;
        }
        Object[] returnArray = new Object[]{obj};
        return returnArray;
    }

    public static Integer[] toIntegers(Object[] aObjects) {
        if (aObjects == null) {
            throw new IllegalArgumentException("aObjects required in Organizer.toIntegers");
        }
        if (aObjects.length < 1) {
            throw new IllegalArgumentException("aObjects.length < 1 ");
        }
        Integer[] ints = new Integer[aObjects.length];
        System.arraycopy(aObjects, 0, ints, 0, ints.length);
        return ints;
    }

    public static double[] toDoubles(List<Double> objects) {
        if (objects == null || objects.isEmpty()) {
            return null;
        }
        double[] rets = new double[objects.size()];
        for (int i = 0; i < rets.length; ++i) {
            rets[i] = objects.get(i);
        }
        return rets;
    }

    public static <T> List<T> fill(int count, T value) {
        if (value == null || count < 1) {
            return null;
        }
        ArrayList<T> list = new ArrayList<T>(count);
        for (int i = 0; i < count; ++i) {
            list.add(value);
        }
        return list;
    }

    public static <T> T at(int i, T[] args) {
        if (args == null || i < 0) {
            return null;
        }
        if (i >= args.length) {
            return null;
        }
        return args[i];
    }

    public static <K, V> Map<K, V> toMap(Object ... params) {
        if (params == null || params.length == 0) {
            return null;
        }
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        Object key = null;
        for (int i = 0; i < params.length; ++i) {
            if (i % 2 == 0) {
                key = params[i];
                continue;
            }
            map.put(key, params[i]);
        }
        if (params.length % 2 == 1) {
            map.put(params[params.length - 1], null);
        }
        return map;
    }

    public static <T> ArrayList<T> toArrayList(List<T> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        ArrayList<T> arrayList = new ArrayList<T>(list.size());
        for (T obj : list) {
            arrayList.add(obj);
        }
        return arrayList;
    }

    public static <T> String[] toArrayString(Collection<T> collection) {
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        String[] outut = new String[collection.size()];
        int i = 0;
        for (T obj : collection) {
            outut[i] = Text.toString(obj);
            ++i;
        }
        return outut;
    }

    public static <T> Queue<T> toQueue(T ... args) {
        if (args == null || args.length == 0) {
            return null;
        }
        LinkedBlockingQueue<T> queue = new LinkedBlockingQueue<T>(args.length);
        queue.addAll(Arrays.asList(args));
        return queue;
    }
}

