/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.util.settings;

import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import nyla.solutions.core.exception.ConfigException;
import nyla.solutions.core.exception.FormatException;
import nyla.solutions.core.exception.MissingConfigPropertiesException;
import nyla.solutions.core.patterns.decorator.Styles;
import nyla.solutions.core.util.Cryption;
import nyla.solutions.core.util.Text;
import nyla.solutions.core.util.settings.ArgsParser;
import nyla.solutions.core.util.settings.Settings;

public abstract class AbstractSettings
implements Settings {
    public static final String RESOURCE_BUNDLE_NAME = "config";
    public static final String SYS_PROPERTY = "config.properties";
    public static final String DEFAULT_PROP_FILE_NAME = "config.properties";
    private boolean alwaysReload = false;
    private boolean useFormatting = false;

    @Override
    public String interpret(String property) {
        try {
            property = Cryption.interpret(property);
            if (property != null && property.indexOf(Styles.DEFAULT_PREFIX) > -1) {
                property = Text.format(property, this.getProperties());
            }
        }
        catch (FormatException e) {
            throw new ConfigException("Format exception for \"" + property + "\"", e);
        }
        return Cryption.interpret(property);
    }

    String getBundleName() {
        return RESOURCE_BUNDLE_NAME;
    }

    @Override
    public void setAlwaysReload(boolean alwaysReload) {
        this.alwaysReload = alwaysReload;
    }

    public boolean isAlwaysReload() {
        return this.alwaysReload;
    }

    @Override
    public String getProperty(String key) {
        return this.getProperty(key, true, false);
    }

    public String getProperty(String key, boolean throwRequiredException) {
        return this.getProperty(key, throwRequiredException, false);
    }

    public String getRawProperty(String key) {
        Map<Object, Object> properties = this.getProperties();
        return (String)properties.get(key);
    }

    public String getProperty(String key, boolean throwRequiredException, boolean checkSecured) {
        String retval = this.getRawProperty(key);
        if (retval == null || retval.length() == 0) {
            if (!throwRequiredException) {
                return null;
            }
            String configSourceLocation = this.getLocation();
            if (configSourceLocation == null) {
                throw new MissingConfigPropertiesException(key);
            }
            throw new ConfigException("Configuration property \"" + key + "\" not found in environment variable, system properties or keys  file:" + configSourceLocation);
        }
        if (checkSecured && !retval.startsWith("{cryption}")) {
            throw new ConfigException("Configuration key \"" + key + "\" must be encypted");
        }
        return Cryption.interpret(retval);
    }

    public Set<Object> keySet() {
        Map<Object, Object> properties = this.getProperties();
        if (properties == null) {
            return null;
        }
        return properties.keySet();
    }

    @Override
    public String[] getPropertyStrings(String key) {
        return Text.split(this.getProperty(key));
    }

    @Override
    public String[] getPropertyStrings(Class<?> aClass, String key) {
        return Text.split(this.getProperty(aClass, key));
    }

    @Override
    public String[] getPropertyStrings(Class<?> aClass, String key, String aDefault) {
        String[] defaultArray = new String[]{aDefault};
        return this.getPropertyStrings(aClass, key, defaultArray);
    }

    @Override
    public String getProperty(Class<?> aClass, String key, ResourceBundle resourceBundle) {
        String results = this.getProperty(aClass, key, "");
        if (results == null || results.length() == 0) {
            results = resourceBundle.getString(key);
        }
        return results;
    }

    @Override
    public String[] getPropertyStrings(Class<?> aClass, String key, String ... aDefault) {
        String property = this.getProperty(aClass, key, "");
        if ("".equals(property)) {
            return aDefault;
        }
        return Text.split(property);
    }

    @Override
    public String getProperty(Class<?> aClass, String key) {
        return this.getProperty(aClass.getName() + "." + key);
    }

    @Override
    public String getProperty(Class<?> aClass, String key, String aDefault) {
        return this.getProperty(aClass.getName() + "." + key, aDefault);
    }

    @Override
    public String getProperty(String key, String aDefault) {
        String retval = null;
        retval = this.getProperty(key, false);
        if (retval == null || retval.length() == 0) {
            retval = aDefault;
        }
        return Cryption.interpret(retval);
    }

    @Override
    public Integer getPropertyInteger(Class<?> aClass, String key, int defaultValue) {
        return this.getPropertyInteger(aClass.getName() + "." + key, defaultValue);
    }

    @Override
    public Character getPropertyCharacter(Class<?> aClass, String key, char defaultValue) {
        String results = this.getProperty(aClass, key, "");
        if (results.length() == 0) {
            return Character.valueOf(defaultValue);
        }
        return Character.valueOf(results.charAt(0));
    }

    @Override
    public Integer getPropertyInteger(String key) {
        Integer iVal = null;
        String sVal = this.getProperty(key);
        if (sVal != null && sVal.length() > 0) {
            iVal = Integer.valueOf(sVal);
        }
        return iVal;
    }

    @Override
    public Integer getPropertyInteger(String key, int aDefault) {
        return this.getPropertyInteger(key, (Integer)aDefault);
    }

    @Override
    public Double getPropertyDouble(Class<?> cls, String key) {
        return this.getPropertyDouble(cls.getName() + "." + key);
    }

    @Override
    public Double getPropertyDouble(Class<?> aClass, String key, double defaultValue) {
        return this.getPropertyDouble(aClass.getName() + "." + key, defaultValue);
    }

    @Override
    public Double getPropertyDouble(String key) {
        Double iVal = null;
        String sVal = this.getProperty(key);
        if (sVal != null && sVal.length() > 0) {
            iVal = Double.valueOf(sVal);
        }
        return iVal;
    }

    @Override
    public Double getPropertyDouble(String key, double aDefault) {
        return this.getPropertyDouble(key, (Double)aDefault);
    }

    @Override
    public Double getPropertyDouble(String key, Double aDefault) {
        Double iVal = null;
        String sVal = this.getProperty(key, false);
        iVal = sVal != null && sVal.length() > 0 ? Double.valueOf(sVal) : aDefault;
        return iVal;
    }

    @Override
    public Integer getPropertyInteger(Class<?> cls, String key) {
        return this.getPropertyInteger(cls.getName() + "." + key);
    }

    @Override
    public Integer getPropertyInteger(Class<?> cls, String key, Integer aDefault) {
        return this.getPropertyInteger(cls.getName() + "." + key, aDefault);
    }

    @Override
    public Integer getPropertyInteger(String key, Integer aDefault) {
        Integer iVal = null;
        String sVal = this.getProperty(key, false);
        iVal = sVal != null && sVal.length() > 0 ? Integer.valueOf(sVal) : aDefault;
        return iVal;
    }

    @Override
    public Boolean getPropertyBoolean(String key) {
        Boolean bVal = null;
        String sVal = this.getProperty(key);
        if (sVal != null && sVal.length() > 0) {
            bVal = Boolean.valueOf(sVal);
        }
        return bVal;
    }

    @Override
    public Boolean getPropertyBoolean(String key, Boolean aBool) {
        Boolean bVal = null;
        String sVal = this.getProperty(key, false);
        bVal = sVal != null && sVal.length() > 0 ? Boolean.valueOf(sVal) : aBool;
        return bVal;
    }

    @Override
    public Boolean getPropertyBoolean(Class<?> aClass, String key, boolean aBool) {
        return this.getPropertyBoolean(aClass.getName() + "." + key, aBool);
    }

    @Override
    public Boolean getPropertyBoolean(String key, boolean aBool) {
        Boolean bVal = null;
        String sVal = this.getProperty(key, false);
        bVal = sVal != null && sVal.length() > 0 ? Boolean.valueOf(sVal) : Boolean.valueOf(aBool);
        return bVal;
    }

    @Override
    public Long getPropertyLong(String key) {
        Long longValue = null;
        String sVal = this.getProperty(key);
        if (sVal != null && sVal.length() > 0) {
            longValue = Long.valueOf(sVal);
        }
        return longValue;
    }

    @Override
    public Long getPropertyLong(Class<?> aClass, String key, long aDefault) {
        return this.getPropertyLong(aClass.getName() + "." + key, (Long)aDefault);
    }

    @Override
    public Long getPropertyLong(Class<?> aClass, String key) {
        return this.getPropertyLong(aClass.getName() + "." + key);
    }

    @Override
    public Long getPropertyLong(String key, long aDefault) {
        return this.getPropertyLong(key, (Long)aDefault);
    }

    @Override
    public Long getPropertyLong(String key, Long aDefault) {
        Long longValue = null;
        String sVal = this.getProperty(key, false);
        longValue = sVal != null && sVal.length() > 0 ? Long.valueOf(sVal) : aDefault;
        return longValue;
    }

    @Override
    public char[] getPropertyPassword(String key) {
        char[] bVal = null;
        String sVal = this.getSecureProperty(key);
        if (sVal == null) {
            throw new MissingConfigPropertiesException(key);
        }
        bVal = sVal.toCharArray();
        return bVal;
    }

    @Override
    public char[] getPropertyPassword(String key, char[] defaultPassword) {
        char[] bVal = null;
        String sVal = this.getSecureProperty(key);
        bVal = sVal != null && sVal.length() > 0 ? sVal.toCharArray() : defaultPassword;
        return bVal;
    }

    @Override
    public char[] getPropertyPassword(String key, String defaultPassword) {
        char[] bVal = null;
        String sVal = this.getSecureProperty(key);
        if (sVal != null && sVal.length() > 0) {
            bVal = sVal.toCharArray();
        } else {
            if (defaultPassword == null) {
                return null;
            }
            bVal = defaultPassword.toCharArray();
        }
        return bVal;
    }

    @Override
    public char[] getPropertyPassword(Class<?> aClass, String key, char[] defaultPassword) {
        return this.getPropertyPassword(aClass.getName() + "." + key, defaultPassword);
    }

    protected String getSecureProperty(String key) {
        return this.getProperty(key, false, true);
    }

    public String getFileSeparator() {
        return System.getProperty("file.separator");
    }

    @Override
    public boolean isUseFormatting() {
        return this.useFormatting;
    }

    @Override
    public void loadArgs(List<String> arguments) {
        if (arguments == null || arguments.isEmpty()) {
            return;
        }
        this.setProperties(ArgsParser.parse(arguments));
    }
}

