/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.data;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Date;
import nyla.solutions.core.data.Auditable;
import nyla.solutions.core.data.Copier;
import nyla.solutions.core.data.Criteria;

public abstract class AbstractAuditable
extends Criteria
implements Auditable,
Copier,
Serializable {
    private static final long serialVersionUID = 4877170428593347353L;
    private Object createUserLogin = null;
    private Object createUserID = null;
    private Date createDate = null;
    private Object updateUserID = null;
    private Timestamp updateDate = null;
    private String deletedCode = "N";

    public static void unDelete(Auditable aAuditable) {
        aAuditable.setDeletedCode("N");
    }

    public static void setDeletedCode(Auditable auditable, String deletedCode) {
        if (auditable == null) {
            return;
        }
        AbstractAuditable.checkDeletedCode(deletedCode);
        auditable.setDeletedCode(deletedCode);
    }

    public static boolean isDelete(Auditable aAuditable) {
        return "Y".equals(aAuditable.getDeletedCode());
    }

    public static void delete(Auditable aAuditable) {
        aAuditable.setDeletedCode("Y");
    }

    public static void checkDeletedCode(String aDeletedCode) throws IllegalArgumentException {
        if (aDeletedCode == null) {
            throw new IllegalArgumentException("deletedCode required");
        }
        if (!"N".equals(aDeletedCode) && !"Y".equals(aDeletedCode)) {
            throw new IllegalArgumentException(aDeletedCode + "is not valid. Expected valid is " + "N" + " or " + "Y");
        }
    }

    public static void copy(Auditable aFrom, Auditable aTo) {
        if (aFrom == null || aTo == null) {
            return;
        }
        if (aTo.getCreateDate() == null && aFrom.getCreateDate() != null) {
            aTo.setCreateDate(aFrom.getCreateDate());
        }
        if (aTo.getUpdateDate() == null && aFrom.getUpdateDate() != null) {
            aTo.setUpdateDate(aFrom.getUpdateDate());
        }
        if (aTo.getCreateUserID() == null && aFrom.getCreateUserID() != null) {
            aTo.setCreateUserID(aFrom.getCreateUserID());
        }
        if (aTo.getUpdateUserID() == null && aFrom.getUpdateUserID() != null) {
            aTo.setUpdateUserID(aFrom.getUpdateUserID());
        }
    }

    public AbstractAuditable() {
    }

    public AbstractAuditable(int aPK) throws IllegalArgumentException {
        super(aPK);
    }

    public AbstractAuditable(Criteria aPK) throws IllegalArgumentException {
        super(aPK);
    }

    public AbstractAuditable(String aPK) throws IllegalArgumentException {
        super(aPK);
    }

    @Override
    public void setPrimaryKey(int primaryKey) throws IllegalArgumentException {
        super.setPrimaryKey(primaryKey);
    }

    @Override
    public Date getCreateDate() {
        if (this.createDate == null) {
            return null;
        }
        return (Date)this.createDate.clone();
    }

    @Override
    public void setCreateDate(Date createDate) {
        this.createDate = createDate == null ? null : new Date(createDate.getTime());
    }

    @Override
    public Object getCreateUserID() {
        return this.createUserID;
    }

    @Override
    public void setCreateUserID(Object createUserID) {
        this.createUserID = createUserID;
    }

    @Override
    public Date getUpdateDate() {
        if (this.updateDate == null) {
            return null;
        }
        return new Date(this.updateDate.getTime());
    }

    public void setUpdateDate(Timestamp updateDate) {
        this.updateDate = updateDate == null ? null : (Timestamp)updateDate.clone();
    }

    @Override
    public void setUpdateDate(Date updateDate) {
        this.updateDate = new Timestamp(updateDate.getTime());
    }

    @Override
    public Object getUpdateUserID() {
        return this.updateUserID;
    }

    @Override
    public void setUpdateUserID(Object updateUserID) {
        this.updateUserID = updateUserID;
    }

    @Override
    public void setPrimaryKeyString(String primaryKey) throws IllegalArgumentException {
        super.setPrimaryKeyString(primaryKey);
    }

    public void setPrimaryKey(Criteria primaryKey) throws IllegalArgumentException {
        super.setPrimaryKeyObject(primaryKey);
    }

    @Override
    public String getDeletedCode() {
        return this.deletedCode;
    }

    @Override
    public void setDeletedCode(String deletedCode) {
        AbstractAuditable.checkDeletedCode(deletedCode);
        this.deletedCode = deletedCode;
    }

    @Override
    public void copy(Copier aCopier) {
        if (!(aCopier instanceof AbstractAuditable)) {
            return;
        }
        AbstractAuditable abstractAudit = (AbstractAuditable)aCopier;
        if (this == abstractAudit) {
            return;
        }
        super.copy(abstractAudit);
        this.createUserID = abstractAudit.createUserID;
        this.createDate = abstractAudit.createDate;
        this.updateUserID = abstractAudit.updateUserID;
        this.updateDate = abstractAudit.updateDate;
        this.deletedCode = abstractAudit.deletedCode;
    }

    public boolean isNew() {
        return this.getPrimaryKey() < 1;
    }

    @Override
    public boolean isDeleted() {
        return "Y".equals(this.deletedCode);
    }

    @Override
    public void delete() {
        this.setDeletedCode("Y");
    }

    public void unDelete() {
        this.setDeletedCode("N");
    }

    public final Object getCreateUserLogin() {
        return this.createUserLogin;
    }

    public final void setCreateUserLogin(String createUserLogin) {
        if (createUserLogin == null) {
            createUserLogin = "";
        }
        this.createUserLogin = createUserLogin;
    }
}

