/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.data;

import java.io.Serializable;
import java.util.Arrays;
import nyla.solutions.core.util.Organizer;

public class MethodCallFact
implements Serializable {
    private static final long serialVersionUID = -5541061978058350647L;
    private String methodName = null;
    private String callerName = null;
    private Object[] arguments = null;

    public MethodCallFact() {
    }

    public MethodCallFact(String callerName, String methodName, Object[] arguments) {
        this.methodName = methodName;
        this.callerName = callerName;
        if (arguments != null) {
            this.arguments = (Object[])arguments.clone();
        }
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public String getCallerName() {
        return this.callerName;
    }

    public void setCallerName(String callerName) {
        this.callerName = callerName;
    }

    public Object[] getArguments() {
        if (this.arguments == null) {
            return null;
        }
        return Organizer.copy(this.arguments);
    }

    public <T> void setArguments(T ... arguments) {
        this.arguments = arguments == null ? null : (Object[])arguments.clone();
    }

    public String toString() {
        return this.getClass().getName() + " callerName=" + this.callerName + " methodName=" + this.methodName;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.arguments);
        result = 31 * result + (this.callerName == null ? 0 : this.callerName.hashCode());
        result = 31 * result + (this.methodName == null ? 0 : this.methodName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MethodCallFact other = (MethodCallFact)obj;
        if (!Arrays.equals(this.arguments, other.arguments)) {
            return false;
        }
        if (this.callerName == null ? other.callerName != null : !this.callerName.equals(other.callerName)) {
            return false;
        }
        return !(this.methodName == null ? other.methodName != null : !this.methodName.equals(other.methodName));
    }
}

