/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.data.clock;

import java.io.Serializable;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Year;
import java.time.format.TextStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAdjusters;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import nyla.solutions.core.util.Scheduler;
import nyla.solutions.core.util.Text;

public class Day
implements Comparable<Day>,
Serializable {
    public static final String DAY_FORMAT = "M/dd/yyyy";
    private static final long serialVersionUID = 7895096174662828704L;
    protected final LocalDate localDate;

    public LocalDate getLocalDate() {
        return this.localDate;
    }

    public Day(int year, int month, int dayOfMonth) {
        this.localDate = LocalDate.of(year, month, dayOfMonth);
    }

    public Day(String date) {
        this(Text.toDate(date, DAY_FORMAT));
    }

    public Day(int year, int dayOfYear) {
        this.localDate = LocalDate.ofYearDay(year, dayOfYear);
    }

    public Day() {
        this.localDate = LocalDate.now();
    }

    public Day(LocalDate theCalendar) {
        this.localDate = theCalendar;
    }

    public Day(Calendar calendar) {
        if (calendar == null) {
            throw new IllegalArgumentException("calendar cannot be null");
        }
        this.localDate = Scheduler.toLocalDate(calendar.getTime());
    }

    public Day(Date date) {
        if (date == null) {
            throw new IllegalArgumentException("dat cannot be null");
        }
        this.localDate = Scheduler.toLocalDateTime(date).toLocalDate();
    }

    public Day(long time) {
        this(new Date(time));
    }

    public Day(Day day) {
        if (day == null) {
            throw new IllegalArgumentException("day cannot be null");
        }
        this.localDate = day.localDate;
    }

    public static Day today() {
        return new Day();
    }

    public LocalDate getDate() {
        return this.localDate;
    }

    @Override
    public int compareTo(Day object) {
        if (object == null) {
            throw new IllegalArgumentException("day cannot be null");
        }
        Day day = object;
        return this.localDate.compareTo(day.localDate);
    }

    public boolean isAfter(Day day) {
        if (day == null) {
            throw new IllegalArgumentException("day cannot be null");
        }
        return this.localDate.isAfter(day.localDate);
    }

    public boolean isBefore(Day day) {
        if (day == null) {
            throw new IllegalArgumentException("day cannot be null");
        }
        return this.localDate.isBefore(day.localDate);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Day)) {
            return false;
        }
        Day day = (Day)object;
        return this.localDate.equals(day.localDate);
    }

    public int hashCode() {
        return this.localDate.hashCode();
    }

    public int getYear() {
        return this.localDate.getYear();
    }

    public int getMonth() {
        return this.localDate.getMonthValue();
    }

    public int getMonthNo() {
        return this.localDate.getMonthValue();
    }

    public int getDayOfMonth() {
        return this.localDate.getDayOfMonth();
    }

    public int getDayOfYear() {
        return this.localDate.getDayOfYear();
    }

    public DayOfWeek getDayOfWeek() {
        return this.localDate.getDayOfWeek();
    }

    public int getDayNumberOfWeek() {
        return this.localDate.get(ChronoField.DAY_OF_WEEK);
    }

    public int getWeekOfYear() {
        return this.localDate.get(ChronoField.ALIGNED_WEEK_OF_YEAR);
    }

    public Day addDays(int nDays) {
        return new Day(this.localDate.plusDays(nDays));
    }

    public Day subtractDays(int nDays) {
        return this.addDays(-nDays);
    }

    public Day addMonths(int nMonths) {
        return new Day(this.localDate.plusMonths(nMonths));
    }

    public Day subtractMonths(int nMonths) {
        return this.addMonths(-nMonths);
    }

    public Day addYears(int nYears) {
        return new Day(this.localDate.plusYears(nYears));
    }

    public Day subtractYears(int nYears) {
        return this.addYears(-nYears);
    }

    public int getDaysInYear() {
        return Year.now().length();
    }

    public boolean isLeapYear() {
        return this.localDate.isLeapYear();
    }

    public static boolean isLeapYear(int year) {
        return new Day(year, 1, 1).isLeapYear();
    }

    public int getDaysInMonth() {
        return this.localDate.getMonth().length(Year.now().isLeap());
    }

    public String getDayName() {
        return this.localDate.getDayOfWeek().getDisplayName(TextStyle.SHORT, Locale.US);
    }

    public long daysBetween(Day day) {
        return Duration.between(this.localDate.atStartOfDay(), day.localDate.atStartOfDay()).toDays();
    }

    public static Day getNthOfMonth(int n, int dayOfWeek, int month, int year) {
        if (dayOfWeek < 0 || dayOfWeek > 6) {
            throw new IllegalArgumentException("Invalid day of week: " + dayOfWeek);
        }
        LocalDateTime localDateTime = LocalDateTime.of(year, month, n, 0, 0);
        return new Day(localDateTime.with(TemporalAdjusters.next(DayOfWeek.of(dayOfWeek))).toLocalDate());
    }

    public static Day getFirstOfMonth(int dayOfWeek, int month, int year) {
        return Day.getNthOfMonth(1, dayOfWeek, month, year);
    }

    public static Day getLastOfMonth(int dayOfWeek, int month, int year) {
        return Day.getNthOfMonth(7, dayOfWeek, month, year);
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        if (this.getMonth() < 9) {
            s.append('0');
        }
        s.append(this.getMonth());
        s.append('/');
        if (this.getDayOfMonth() < 10) {
            s.append('0');
        }
        s.append(this.getDayOfMonth());
        s.append('/');
        s.append(this.getYear());
        s.append(" ");
        s.append(this.getDayName());
        return s.toString();
    }

    public boolean isSameDay(Day compared) {
        if (compared == null) {
            return false;
        }
        return this.getMonth() == compared.getMonth() && this.getDayOfMonth() == compared.getDayOfMonth() && this.getYear() == compared.getYear();
    }
}

