/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.data.clock;

import java.io.Serializable;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.temporal.ChronoField;
import nyla.solutions.core.data.clock.Day;

public class Time
implements Serializable {
    private static final long serialVersionUID = -7760994938523990073L;
    private LocalDateTime localDateTime;

    public Time(int year, int month, int dayOfMonth, int hours, int minutes, int seconds) {
        LocalDateTime.of(year, month, dayOfMonth, hours, minutes, seconds);
    }

    public Time(LocalDateTime date) {
        this.localDateTime = date;
    }

    public static Time now() {
        return new Time();
    }

    public void assignDate(LocalDateTime date) {
        if (date == null) {
            return;
        }
        this.localDateTime = date;
    }

    public Time(Day day, int hours, int minutes, int seconds) {
        this(day.getYear(), day.getMonth(), day.getDayOfMonth(), hours, minutes, seconds);
    }

    public Time(int hours, int minutes, int seconds) {
        this(new Day(), hours, minutes, seconds);
    }

    public Time() {
        this.localDateTime = LocalDateTime.now();
    }

    public int getHour24() {
        return this.localDateTime.get(ChronoField.CLOCK_HOUR_OF_AMPM);
    }

    public int getHour() {
        return this.localDateTime.getHour();
    }

    public String getAmOrPm() {
        return this.localDateTime.get(ChronoField.AMPM_OF_DAY) == 0 ? "AM" : "PM";
    }

    public int getMinutes() {
        return this.localDateTime.getMinute();
    }

    public int getSeconds() {
        return this.localDateTime.getSecond();
    }

    public long getMilliSeconds() {
        return this.localDateTime.get(ChronoField.MILLI_OF_SECOND);
    }

    public boolean isAfter(Time time) {
        return this.localDateTime.isAfter(time.localDateTime);
    }

    public boolean isBefore(Time time) {
        return this.localDateTime.isBefore(time.localDateTime);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.localDateTime == null ? 0 : this.localDateTime.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Time other = (Time)obj;
        return !(this.localDateTime == null ? other.localDateTime != null : !this.localDateTime.equals(other.localDateTime));
    }

    public void addHours(int nHours) {
        this.localDateTime = this.localDateTime.plusHours(nHours);
    }

    public void addMinutes(long nMinutes) {
        this.localDateTime = this.localDateTime.plusMinutes(nMinutes);
    }

    public void addSeconds(long nSeconds) {
        this.localDateTime = this.localDateTime.plusSeconds(nSeconds);
    }

    public void addNanoSeconds(long nNanoSeconds) {
        this.localDateTime.plusNanos(nNanoSeconds);
    }

    public long milliSecondsBetween(Time time) {
        return Duration.between(this.localDateTime, time.localDateTime).toMillis();
    }

    public long secondsBetween(Time time) {
        return Duration.between(this.localDateTime, time.localDateTime).getSeconds();
    }

    public long minutesBetween(Time time) {
        return Duration.between(this.localDateTime, time.localDateTime).toMinutes();
    }

    public double hoursBetween(Time time) {
        return Duration.between(this.localDateTime, time.localDateTime).toHours();
    }

    public String toString() {
        StringBuffer string = new StringBuffer();
        string.append(super.toString());
        string.append(' ');
        if (this.getHour24() < 10) {
            string.append('0');
        }
        string.append(this.getHour24());
        string.append(':');
        if (this.getMinutes() < 10) {
            string.append('0');
        }
        string.append(this.getMinutes());
        string.append(':');
        if (this.getSeconds() < 10) {
            string.append('0');
        }
        string.append(this.getSeconds());
        string.append(',');
        string.append(this.getMilliSeconds());
        return string.toString();
    }

    public LocalDateTime getLocalDateTime() {
        return this.localDateTime;
    }

    public void setHour24(int startHour24) {
        this.localDateTime = this.localDateTime.with(ChronoField.HOUR_OF_DAY, startHour24);
    }
}

