/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.data.clock;

import java.io.Serializable;
import java.time.LocalDateTime;
import nyla.solutions.core.data.clock.Day;
import nyla.solutions.core.data.clock.Time;
import nyla.solutions.core.data.clock.TimeInterval;
import nyla.solutions.core.exception.RequiredException;
import nyla.solutions.core.util.Scheduler;

public class TimeSlot
implements Serializable,
Comparable<Object>,
TimeInterval {
    private LocalDateTime start;
    private LocalDateTime end;
    private static final long serialVersionUID = -6155840093186057564L;

    public TimeSlot() {
        this.start = null;
        this.end = null;
    }

    public TimeSlot(LocalDateTime start, LocalDateTime end) {
        this.start = start;
        this.end = end;
    }

    public long getDurationhours() {
        return Scheduler.durationHours(this.start, this.end);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("TimeSlot [start=").append(this.start).append(", end=").append(this.end).append("]");
        return builder.toString();
    }

    public TimeSlot nextTimeSlot(int intervalSeconds, Time cutOffTime) {
        LocalDateTime newEnd = this.end.plusSeconds(intervalSeconds);
        TimeSlot newTimeSlot = new TimeSlot(this.end, newEnd);
        if (cutOffTime == null) {
            return newTimeSlot;
        }
        if (newEnd.isAfter(cutOffTime.getLocalDateTime())) {
            return null;
        }
        if (newTimeSlot.getEndDate().isAfter(cutOffTime.getLocalDateTime())) {
            return null;
        }
        return newTimeSlot;
    }

    public double getDurationMinutes() {
        return Scheduler.durationMinutes(this.start, this.end);
    }

    public double getDurationSeconds() {
        return Scheduler.durationSeconds(this.start, this.end);
    }

    @Override
    public LocalDateTime getStartDate() {
        return this.start;
    }

    @Override
    public LocalDateTime getEndDate() {
        if (this.end == null) {
            return null;
        }
        return this.end;
    }

    public Time getEndTime() {
        return new Time(this.end);
    }

    public Time getStartTime() {
        return new Time(this.start);
    }

    public static TimeSlot firstSlot(Day day, Time start, int intervalSeconds) {
        if (day == null) {
            throw new RequiredException("date in TimeSlot.firstSlot");
        }
        LocalDateTime startDate = Scheduler.toLocalDateTime(day, start);
        LocalDateTime end = startDate.plusSeconds(intervalSeconds);
        return new TimeSlot(startDate, end);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.end == null ? 0 : this.end.hashCode());
        result = 31 * result + (this.start == null ? 0 : this.start.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TimeSlot other = (TimeSlot)obj;
        if (this.end == null ? other.end != null : !this.end.equals(other.end)) {
            return false;
        }
        return !(this.start == null ? other.start != null : !this.start.equals(other.start));
    }

    @Override
    public int compareTo(Object object) {
        TimeSlot other = (TimeSlot)object;
        if (this.equals(other)) {
            return 0;
        }
        if (this.start == null) {
            return -1;
        }
        if (other.start == null) {
            return 1;
        }
        if (this.start.isBefore(other.start)) {
            return -1;
        }
        return 1;
    }

    @Override
    public void setStartDate(LocalDateTime start) {
        this.start = start;
    }

    @Override
    public void setEndDate(LocalDateTime end) {
        this.end = end;
    }
}

