/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.data.conversation;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import nyla.solutions.core.data.conversation.BaggedObject;
import nyla.solutions.core.data.conversation.DateBag;
import nyla.solutions.core.exception.NonSerializableException;
import nyla.solutions.core.util.Organizer;

public class ArrayListBag<T extends Serializable>
implements Serializable,
BaggedObject<ArrayList<T>> {
    private static final long serialVersionUID = 4995496063381565327L;
    private Object[] arrayObj;

    public ArrayListBag() {
    }

    public ArrayListBag(ArrayList<T> list) {
        this.bag(list);
    }

    @Override
    public void bag(ArrayList<T> unBaggedObject) {
        if (unBaggedObject == null || unBaggedObject.isEmpty()) {
            return;
        }
        this.arrayObj = new Object[unBaggedObject.size()];
        BaggedObject<Date> obj = null;
        for (int i = 0; i < this.arrayObj.length; ++i) {
            obj = (BaggedObject<Date>)unBaggedObject.get(i);
            if (!(obj instanceof Serializable)) {
                throw new NonSerializableException("Non serializable object at index " + i);
            }
            if (obj instanceof Date) {
                obj = new DateBag((Date)((Object)obj));
            } else if (obj instanceof List) {
                obj = new ArrayListBag(Organizer.toArrayList((List)((Object)obj)));
            }
            this.arrayObj[i] = obj;
        }
    }

    public Object[] getArrayObj() {
        if (this.arrayObj == null) {
            return null;
        }
        Object[] copy = new Object[this.arrayObj.length];
        System.arraycopy(this.arrayObj, 0, copy, 0, copy.length);
        return copy;
    }

    public void setArrayObj(Object[] arrayObj) {
        if (arrayObj == null) {
            return;
        }
        this.arrayObj = new Object[arrayObj.length];
        System.arraycopy(arrayObj, 0, this.arrayObj, 0, this.arrayObj.length);
    }

    @Override
    public ArrayList<T> unbag() {
        if (this.arrayObj == null || this.arrayObj.length == 0) {
            return null;
        }
        ArrayList<Object> list = new ArrayList<Object>(this.arrayObj.length);
        Object value = null;
        for (int i = 0; i < this.arrayObj.length; ++i) {
            value = this.arrayObj[i];
            if (value instanceof BaggedObject) {
                value = ((BaggedObject)value).unbag();
            }
            list.add(value);
        }
        return list;
    }
}

