/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.ds.security;

import java.security.Principal;
import nyla.solutions.core.security.data.SecurityUser;

public class LdapSecurityUser
extends SecurityUser {
    private static final long serialVersionUID = -1090403112093383311L;
    private final String dn;

    public LdapSecurityUser(String uid) {
        this(uid, (String)null);
    }

    public LdapSecurityUser(String uid, String dn) {
        super(uid);
        this.dn = dn;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("LdapSecurityUser [dn=").append(this.dn).append(", getName()=").append(this.getName()).append(", getGroups()=").append(this.getGroups()).append("]");
        return builder.toString();
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (super.equals(obj)) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LdapSecurityUser other = (LdapSecurityUser)obj;
        return !(this.dn == null ? other.dn != null : !this.dn.equals(other.dn));
    }

    @Override
    public Boolean apply(Principal principal) {
        if (this == principal) {
            return Boolean.TRUE;
        }
        if (Boolean.TRUE.equals(super.apply(principal))) {
            return Boolean.TRUE;
        }
        if (this.getClass() != principal.getClass()) {
            return false;
        }
        LdapSecurityUser other = (LdapSecurityUser)principal;
        if (this.dn == null || other.dn == null) {
            return false;
        }
        return this.dn.equals(other.dn);
    }
}

