/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.exception.fault;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;
import nyla.solutions.core.exception.fault.Fault;
import nyla.solutions.core.util.Debugger;
import nyla.solutions.core.util.Presenter;

public class FaultException
extends RuntimeException
implements Fault {
    private static final long serialVersionUID = -8500125749384413080L;
    public static final String DEFAULT_ERROR_CATEGORY_NM = "DEFAULT";
    private String source = null;
    private Object argument;
    private String notes = null;
    private String module = null;
    private String operation = null;
    private String category = null;
    private String code = null;
    private String argumentId = null;
    private String argumentType = null;
    private String message = null;

    public FaultException(String message, String notes, String programName, String functionName, String errorCategory, String errorCode) {
        super(message);
        this.notes = notes;
        this.module = programName;
        this.operation = functionName;
        this.category = errorCategory;
        this.code = errorCode;
    }

    public FaultException() {
    }

    public FaultException(String message, Throwable cause) {
        super(message, cause);
    }

    public FaultException(String message) {
        super(message);
        this.notes = message;
    }

    public FaultException(Throwable cause) {
        super(cause);
    }

    public FaultException(String message, String functionName, String errorCategory, String errorCode, String programName) {
        super(message);
        this.operation = functionName;
        this.category = errorCategory;
        this.code = errorCode;
        this.module = programName;
        this.notes = message;
    }

    public FaultException(String message, Throwable cause, String functionName, String errorCategory, String errorCode, String programName) {
        super(message, cause);
        this.operation = functionName;
        this.category = errorCategory;
        this.code = errorCode;
        this.module = programName;
    }

    public FaultException(Throwable cause, String functionName, String errorCategory, String errorCode, String programName) {
        super(cause);
        this.operation = functionName;
        this.category = errorCategory;
        this.code = errorCode;
        this.module = programName;
    }

    public String stackTrace() {
        return FaultException.stackTrace(this);
    }

    public static String stackTrace(Throwable e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        return sw.toString();
    }

    @Override
    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    @Override
    public String getCategory() {
        return this.category;
    }

    @Override
    public String getCode() {
        return this.code;
    }

    @Override
    public String getModule() {
        return this.module;
    }

    public void setModule(String module) {
        this.module = module;
    }

    @Override
    public void setCategory(String errorCategory) {
        this.category = errorCategory;
    }

    @Override
    public void setCode(String errorCode) {
        this.code = errorCode;
    }

    @Override
    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public void copy(Object object) {
        FaultException other = (FaultException)object;
        this.notes = other.notes;
        this.module = other.module;
        this.operation = other.operation;
        this.category = other.category;
        this.code = other.code;
        this.argument = other.argument;
        this.setMessage(other.getMessage());
        this.setStackTrace(other.getStackTrace());
    }

    protected void formatMessage(String aID, Map<Object, Object> aBindValues) {
        Presenter presenter = Presenter.getPresenter(this.getClass());
        this.message = presenter.getText(aID, aBindValues);
    }

    protected void setMessage(String aMessage) {
        this.message = aMessage;
    }

    @Override
    public Object getArgument() {
        return this.argument;
    }

    public void setArgument(Object argument) {
        this.argument = argument;
    }

    @Override
    public String getMessage() {
        if (this.message != null && this.message.length() > 0) {
            return this.message;
        }
        return super.getMessage();
    }

    public FaultException(String aID, String aMessage) {
        Presenter presenter = Presenter.getPresenter(this.getClass());
        this.message = new StringBuffer(presenter.getText(aID)).append(" ").append(aMessage).toString();
    }

    @Override
    public String getErrorStackTrace() {
        return Debugger.stackTrace(this);
    }

    @Override
    public String getArgumentId() {
        return this.argumentId;
    }

    public void setArgumentId(String argumentId) {
        this.argumentId = argumentId;
    }

    @Override
    public String getArgumentType() {
        return this.argumentType;
    }

    public void setArgumentType(String argumentType) {
        this.argumentType = argumentType;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }
}

