/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.exception.fault;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import nyla.solutions.core.exception.NotImplementedException;
import nyla.solutions.core.exception.SystemException;
import nyla.solutions.core.exception.fault.Fault;
import nyla.solutions.core.exception.fault.FaultFormatTextDecorator;
import nyla.solutions.core.patterns.decorator.TextDecorator;
import nyla.solutions.core.util.Text;

public class FaultsHtmlTextDecorator
implements TextDecorator<Collection<Fault>> {
    public static final String HTML_ROW_FAULT_TEMPLATE = "FaultsHtmlTextDecorator_ROW";
    public static final String FaultsHtmlTextDecorator_TEMPLATE = "FaultsHtmlTextDecorator";
    private final Collection<Fault> faults;

    public FaultsHtmlTextDecorator(Collection<Fault> faults) {
        this.faults = faults;
    }

    @Override
    public String getText() {
        if (this.faults == null || this.faults.isEmpty()) {
            return null;
        }
        FaultFormatTextDecorator decorator = new FaultFormatTextDecorator();
        decorator.setTemplateName(HTML_ROW_FAULT_TEMPLATE);
        StringBuilder faultsTableRows = new StringBuilder();
        for (Fault fault : this.faults) {
            if (fault == null) continue;
            decorator.setTarget(fault);
            faultsTableRows.append(decorator.getText());
        }
        if (faultsTableRows.length() == 0) {
            return null;
        }
        try {
            HashMap<Object, Object> map = new HashMap<Object, Object>();
            map.put("faultsTableRows", faultsTableRows.toString());
            return Text.formatFromTemplate(FaultsHtmlTextDecorator_TEMPLATE, map, Locale.US);
        }
        catch (IOException e) {
            throw new SystemException(e);
        }
    }

    @Override
    public void setTarget(Collection<Fault> target) {
        throw new NotImplementedException();
    }

    @Override
    public Collection<Fault> getTarget() {
        return this.faults;
    }
}

