/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.io;

import java.io.File;
import java.util.EventObject;
import nyla.solutions.core.io.FileMonitor;

public class FileEvent
extends EventObject {
    public static final short ADDED = 1;
    public static final short CHANGED = 3;
    public static final short REMOVED = 2;
    private short eventType = (short)3;
    static final long serialVersionUID = FileEvent.class.getName().hashCode();

    public FileEvent(Object source, short eventType) {
        super(source);
        if (!(source instanceof File)) {
            throw new IllegalArgumentException("Provided source must be a file");
        }
        this.setEventType(eventType);
    }

    public static FileEvent createAddedEvent(File aFile) {
        return new FileEvent(aFile, 1);
    }

    public static FileEvent createChangedEvent(File aFile) {
        return new FileEvent(aFile, 3);
    }

    public static FileEvent createRemovedEvent(File aFile) {
        return new FileEvent(aFile, 2);
    }

    public File getFile() {
        File file = (File)this.getSource();
        if (file != null) {
            FileMonitor.waitFor(file);
        }
        return file;
    }

    public short getEventType() {
        return this.eventType;
    }

    public boolean isAdded() {
        return this.eventType == 1;
    }

    public boolean isChanged() {
        return this.eventType == 3;
    }

    @Override
    public String toString() {
        File file = (File)this.getSource();
        if (file == null) {
            return "null";
        }
        String name = file.getName();
        switch (this.eventType) {
            case 1: {
                return "ADDED   " + name;
            }
            case 2: {
                return "REMOVED " + name;
            }
        }
        return "CHANGED " + name;
    }

    public boolean isRemoved() {
        return this.eventType == 2;
    }

    private void setEventType(short eventType) {
        if (eventType != 1 && eventType != 2 && eventType != 3) {
            throw new IllegalArgumentException("Invalid eventType code " + eventType);
        }
        this.eventType = eventType;
    }
}

