/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.patterns.creational.builder.mapped;

import java.util.Map;
import java.util.TreeMap;
import nyla.solutions.core.exception.RequiredException;
import nyla.solutions.core.exception.SystemException;
import nyla.solutions.core.patterns.creational.builder.mapped.MapFactoryById;
import nyla.solutions.core.util.Text;

public class ReLookupTextMapFactory<K, V>
implements MapFactoryById<K, V> {
    private TreeMap<String, Map<K, V>> lookupTable = null;
    private String id = null;

    @Override
    public Map<K, V> createMap() {
        if (Text.isNull(this.id)) {
            throw new RequiredException("ReLookupTextMap.id");
        }
        if (this.lookupTable == null || this.lookupTable.isEmpty()) {
            throw new RequiredException("this.lookupTable in ReLookupTextMapById.lookupTextMap");
        }
        String re = null;
        for (Map.Entry<String, Map<K, V>> entry : this.lookupTable.entrySet()) {
            re = entry.getKey();
            if (!Text.matches(this.id, re)) continue;
            return entry.getValue();
        }
        throw new SystemException("No map found for \"" + this.id + " in regExp keys " + this.lookupTable.keySet());
    }

    public Map<String, Map<K, V>> getLookupTable() {
        return this.lookupTable;
    }

    public void setLookupTable(Map<String, Map<K, V>> lookupTable) {
        this.lookupTable = new TreeMap<String, Map<String, Map<K, V>>>(lookupTable);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }
}

