/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.patterns.creational.proxy;

import java.lang.reflect.Method;
import java.util.ArrayList;
import nyla.solutions.core.data.MethodCallFact;
import nyla.solutions.core.exception.RequiredException;
import nyla.solutions.core.exception.SystemException;
import nyla.solutions.core.util.Debugger;

public class ObjectProxy {
    public static Object executeMethod(Object object, MethodCallFact methodCallFact) throws Exception {
        if (object == null) {
            throw new RequiredException("object");
        }
        if (methodCallFact == null) {
            throw new RequiredException("methodCallFact");
        }
        return ObjectProxy.executeMethod(object, methodCallFact.getMethodName(), methodCallFact.getArguments());
    }

    public static Object executeMethod(Object aObject, String methodName, Object[] aArguments) throws Exception {
        Class[] parameterTypes = null;
        ArrayList parameterTypeArrayList = null;
        if (aArguments != null && aArguments.length > 0) {
            parameterTypeArrayList = new ArrayList(aArguments.length);
            for (int i = 0; i < aArguments.length; ++i) {
                if (aArguments[i] == null) {
                    parameterTypeArrayList.add(Object.class);
                    continue;
                }
                parameterTypeArrayList.add(aArguments[i].getClass());
            }
            parameterTypes = parameterTypeArrayList.toArray(new Class[parameterTypeArrayList.size()]);
        }
        Method method = null;
        method = aObject.getClass().getDeclaredMethod(methodName, parameterTypes);
        try {
            return method.invoke(aObject, aArguments);
        }
        catch (Exception e) {
            throw new SystemException("methodName=" + methodName + " object=" + aObject.getClass().getName() + " parameters=" + parameterTypeArrayList + " EXCEPTION=" + Debugger.stackTrace(e));
        }
    }
}

