/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.patterns.decorator;

import java.util.ArrayList;
import java.util.Collection;
import nyla.solutions.core.data.Textable;
import nyla.solutions.core.patterns.decorator.TextDecorator;

public class MacroTextDecorator
implements TextDecorator<Textable> {
    private Textable target = null;
    private Collection<TextDecorator<Textable>> textables = new ArrayList<TextDecorator<Textable>>();
    private String separator = "";

    public MacroTextDecorator() {
    }

    public MacroTextDecorator(String separator) {
        this.separator = separator;
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public MacroTextDecorator(Textable target, Collection<TextDecorator<Textable>> textables) {
        this.target = target;
        this.textables = textables;
    }

    @Override
    public String getText() {
        StringBuilder builder = new StringBuilder();
        if (this.target != null && this.textables.isEmpty()) {
            builder.append(this.target.getText());
        }
        String decoration = null;
        for (TextDecorator<Textable> textDecorator : this.textables) {
            if (this.target != null && textDecorator.getTarget() == null) {
                textDecorator.setTarget(this.target);
            }
            if ((decoration = textDecorator.getText()) == null || decoration.length() == 0) continue;
            if (builder.length() != 0) {
                builder.append(this.separator);
            }
            builder.append(decoration);
        }
        return builder.toString();
    }

    @Override
    public Textable getTarget() {
        return this.target;
    }

    @Override
    public void setTarget(Textable target) {
        this.target = target;
    }

    public Collection<TextDecorator<Textable>> getTextables() {
        return this.textables;
    }

    public void setTextables(Collection<TextDecorator<Textable>> textables) {
        this.textables = textables;
    }
}

