/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.patterns.decorator;

import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import nyla.solutions.core.exception.FormatException;
import nyla.solutions.core.patterns.decorator.TextStyles;
import nyla.solutions.core.util.Config;
import nyla.solutions.core.util.Text;

public abstract class TextStylist
implements TextStyles {
    private String templatePrefix = Config.getProperty(this.getClass(), "templatePrefix", DEFAULT_PREFIX);
    private String templateSuffix = Config.getProperty(this.getClass(), "templateSuffix", DEFAULT_SUFFIX);

    @Override
    public String format(String bindText, Object bindObj) throws FormatException {
        return this.format(bindText, bindObj, Text.DATE_FORMAT);
    }

    @Override
    public void formatMap(Map<Object, Object> map) throws FormatException {
        if (map == null || map.isEmpty()) {
            return;
        }
        Object key = null;
        Object value = null;
        String text = null;
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            key = entry.getKey();
            value = entry.getValue();
            if (!(value instanceof String) || (text = (String)value).indexOf(this.getTemplatePrefix()) <= -1) continue;
            map.put(key, this.format(text, map));
        }
    }

    @Override
    public String getTemplatePrefix() {
        return this.templatePrefix;
    }

    public void setTemplatePrefix(String templatePrefix) {
        this.templatePrefix = templatePrefix;
    }

    @Override
    public String getTemplateSuffix() {
        return this.templateSuffix;
    }

    public void setTemplateSuffix(String templateSuffix) {
        this.templateSuffix = templateSuffix;
    }

    @Override
    public void formatWriter(String text, Object bindObj, String dateFormat, Writer writer) throws IOException, FormatException {
        writer.write(this.format(text, bindObj, dateFormat));
    }
}

