/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.patterns.iteration;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import nyla.solutions.core.exception.CommunicationException;
import nyla.solutions.core.patterns.Disposable;

public class ResultSetIterator
implements Iterator<ResultSet>,
Disposable {
    private ResultSet resultSet;

    public ResultSetIterator(ResultSet rs) {
        this.resultSet = rs;
    }

    @Override
    public boolean hasNext() {
        try {
            if (this.resultSet == null) {
                return false;
            }
            if (!this.resultSet.next()) {
                this.dispose();
                return false;
            }
            return true;
        }
        catch (SQLException e) {
            this.dispose();
            throw new CommunicationException(e.getMessage(), e);
        }
    }

    @Override
    public ResultSet next() throws NoSuchElementException {
        if (this.resultSet == null) {
            throw new NoSuchElementException();
        }
        return this.resultSet;
    }

    @Override
    public void dispose() {
        try {
            if (this.resultSet != null) {
                this.resultSet.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.resultSet = null;
    }

    @Override
    public void remove() {
    }
}

