/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.patterns.jdbc.batch;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.function.Supplier;
import nyla.solutions.core.exception.ConnectionException;
import nyla.solutions.core.exception.DataException;
import nyla.solutions.core.patterns.Connectable;
import nyla.solutions.core.patterns.conversion.Converter;

public class SelectResultSetConverterSupplier<T>
implements Supplier<T>,
Connectable {
    private Connection connection;
    private final Supplier<Connection> connections;
    private final Converter<ResultSet, T> converter;
    private String sql;
    private PreparedStatement statement;
    private ResultSet resultSet;
    private Object[] parameters;

    public SelectResultSetConverterSupplier(Supplier<Connection> connections, Converter<ResultSet, T> converter, String sql) throws SQLException {
        this(connections, converter, sql, null);
    }

    public SelectResultSetConverterSupplier(Supplier<Connection> connections, Converter<ResultSet, T> converter, String sql, Object[] parameters) {
        this.converter = converter;
        this.sql = sql;
        this.connections = connections;
    }

    @Override
    public T get() {
        if (this.resultSet == null) {
            this.connect();
        }
        try {
            if (!this.resultSet.next()) {
                return null;
            }
            return this.converter.convert(this.resultSet);
        }
        catch (SQLException e) {
            throw new DataException(e);
        }
    }

    @Override
    public void connect() throws ConnectionException {
        this.connection = this.connections.get();
        try {
            this.statement = this.connection.prepareStatement(this.sql);
            if (this.sql.indexOf("?") > -1 && this.parameters != null && this.parameters.length > 0) {
                for (int i = 0; i < this.parameters.length; ++i) {
                    this.statement.setObject(i + 1, this.parameters[i]);
                }
            }
            this.resultSet = this.statement.executeQuery();
        }
        catch (SQLException e) {
            throw new DataException(e);
        }
    }

    @Override
    public void dispose() {
        if (this.connection != null) {
            try {
                this.resultSet.close();
                this.statement.close();
            }
            catch (SQLException e) {
                throw new ConnectionException(e);
            }
            finally {
                try {
                    this.connection.close();
                }
                catch (SQLException e) {
                    throw new ConnectionException(e);
                }
            }
        }
        this.connection = null;
        this.statement = null;
        this.resultSet = null;
    }

    public Object[] getParameters() {
        return this.parameters;
    }

    public void setParameters(Object ... parameters) {
        this.parameters = parameters;
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }
}

