/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.patterns.jdbc.office;

import java.io.IOException;
import java.io.Reader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import nyla.solutions.core.io.csv.CsvReader;
import nyla.solutions.core.patterns.creational.Creator;

public class CsvJdbcLoader {
    public long load(Creator<Connection> creator, Reader csv, String sql, boolean hasHeader) throws SQLException, IOException {
        try (Connection connection = creator.create();){
            long l;
            block12: {
                PreparedStatement preparedStatement = connection.prepareStatement(sql);
                try {
                    l = this.load(preparedStatement, csv, sql, hasHeader);
                    if (preparedStatement == null) break block12;
                }
                catch (Throwable throwable) {
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                preparedStatement.close();
            }
            return l;
        }
    }

    public long load(PreparedStatement preparedStatement, Reader csv, String sql, boolean hasHeaderRow) throws SQLException, IOException {
        CsvReader csvReader = new CsvReader(csv);
        int rowCnt = csvReader.size();
        long loadCnt = 0L;
        for (int row = 0; row < rowCnt; ++row) {
            if (row == 0 && hasHeaderRow) continue;
            List<String> rowList = csvReader.row(row);
            for (int cols = 0; cols < rowList.size(); ++cols) {
                preparedStatement.setObject(cols + 1, rowList.get(cols));
            }
            preparedStatement.addBatch();
            ++loadCnt;
        }
        preparedStatement.executeBatch();
        return loadCnt;
    }
}

