/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.patterns.machineLearning.associations;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import nyla.solutions.core.patterns.iteration.Iterate;
import nyla.solutions.core.patterns.machineLearning.associations.ProductAssociation;
import nyla.solutions.core.patterns.machineLearning.associations.ProductTransition;
import nyla.solutions.core.patterns.observer.SubjectObserver;
import nyla.solutions.core.patterns.observer.Topic;

public class AssociationProbabilities<K> {
    private final double minSup;
    private final long numTransactions;
    private final double confidence;
    private final Topic<ProductAssociation> topic = new Topic("associations");
    private Map<K, Set<String>> pivot = new HashMap<K, Set<String>>();
    private Map<String, ProductAssociation> associateMap = new HashMap<String, ProductAssociation>();
    private Map<String, Integer> count = new HashMap<String, Integer>();
    private Set<String> frequentCandidates = new HashSet<String>();
    private Set<String> set = null;

    public AssociationProbabilities(double minimum, long numTransactions, double confidence, SubjectObserver<ProductAssociation> output_schema) {
        this(minimum, numTransactions, confidence);
        this.addObserver(output_schema);
    }

    public void addObserver(SubjectObserver<ProductAssociation> output_schema) {
        this.topic.add(output_schema);
    }

    public AssociationProbabilities(Double minimum, long numOfTransactions, double confidence) {
        this.minSup = minimum;
        this.numTransactions = numOfTransactions;
        this.confidence = confidence;
    }

    public void learn(ProductTransition<K> order) {
        double productProbaliity;
        this.set = this.pivot.get(order.getTransitionId());
        if (this.set == null) {
            this.set = new HashSet<String>();
        }
        this.set.add(order.getProductName());
        this.pivot.put(order.getTransitionId(), this.set);
        Integer productCount = this.count.get(order.getProductName());
        if (productCount == null) {
            productCount = 0;
        }
        if ((productProbaliity = (double)productCount.intValue() / (double)this.numTransactions) >= this.minSup) {
            this.frequentCandidates.add(order.getProductName());
        }
        this.count.put(order.getProductName(), productCount + 1);
    }

    public void learn(Iterate<ProductTransition<K>> input_table) {
        ProductTransition<K> order = null;
        while ((order = input_table.next()) != null) {
            this.learn(order);
        }
        this.notifyFavoriteAssociations();
    }

    public void notifyFavoriteAssociations() {
        this.pivot.entrySet().parallelStream().forEach(entry -> this.frequentCandidates.parallelStream().forEach(favorite -> {
            if (((Set)entry.getValue()).contains(favorite)) {
                this.countAssociates((String)favorite, (Set)entry.getValue());
            }
        }));
    }

    protected void countAssociates(String favorite, Set<String> value) {
        ProductAssociation productAprioriAssociation = this.associateMap.get(favorite);
        if (productAprioriAssociation == null) {
            productAprioriAssociation = new ProductAssociation(favorite);
        }
        this.associateMap.put(favorite, productAprioriAssociation);
        for (String associate : value) {
            productAprioriAssociation.addAssociate(associate);
            int cnt = this.whatIsAssocCnt(favorite, associate);
            double associatePercent = (double)cnt / (double)this.numTransactions;
            if (!(associatePercent >= this.confidence)) continue;
            this.notifyFavoriteAssociations(productAprioriAssociation.filterAssociate(associate));
        }
        this.associateMap.put(favorite, productAprioriAssociation);
    }

    private void notifyFavoriteAssociations(ProductAssociation order) {
        this.topic.notify(order);
    }

    protected int whatIsAssocCnt(String favorite, String associated) {
        ProductAssociation out = this.associateMap.get(favorite);
        if (out == null) {
            return 0;
        }
        Integer cnt = out.countAssociate(associated);
        return cnt != null ? cnt : 0;
    }
}

