/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.patterns.reflection;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Arrays;
import nyla.solutions.core.patterns.reflection.ComplexTypeSchema;
import nyla.solutions.core.patterns.reflection.Mirror;
import nyla.solutions.core.patterns.reflection.PrimitiveTypeSchema;
import nyla.solutions.core.patterns.reflection.TypeSchema;

public class MethodSchema
implements Serializable {
    private static final long serialVersionUID = -8831063503559316388L;
    private final String name;
    private TypeSchema[] inputArguments;
    private TypeSchema returnClassSchema;
    private static String argName = "arg";

    public MethodSchema(Method method) {
        this.name = method.getName();
        Class<?>[] parameterTypes = method.getParameterTypes();
        this.inputArguments = new TypeSchema[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            Class<?> inputArgClass = parameterTypes[i];
            this.inputArguments[i] = Mirror.isPrimitive(inputArgClass) ? new PrimitiveTypeSchema(argName + i, inputArgClass) : new ComplexTypeSchema(argName + i, inputArgClass);
        }
        Class<?> returnClass = method.getReturnType();
        this.returnClassSchema = Mirror.isPrimitive(returnClass) ? new PrimitiveTypeSchema(returnClass) : new ComplexTypeSchema(returnClass);
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return "MethodSchema [name=" + this.name + ", inputArguments=" + (this.inputArguments != null ? Arrays.asList(this.inputArguments) : null) + ", returnClassSchema=" + this.returnClassSchema + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.inputArguments);
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.returnClassSchema == null ? 0 : this.returnClassSchema.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MethodSchema other = (MethodSchema)obj;
        if (!Arrays.equals(this.inputArguments, other.inputArguments)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.returnClassSchema == null ? other.returnClassSchema != null : !this.returnClassSchema.equals(other.returnClassSchema));
    }
}

