/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.patterns.reflection;

import java.lang.instrument.Instrumentation;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import nyla.solutions.core.operations.ClassPath;
import nyla.solutions.core.patterns.creational.generator.JavaBeanGeneratorCreator;
import nyla.solutions.core.patterns.search.ReLookup;
import nyla.solutions.core.security.user.data.UserProfile;
import nyla.solutions.core.util.Config;

public class ObjectClassSizer {
    private int defaultStringSizeBytes = Config.getPropertyInteger(ObjectClassSizer.class, "defaultStringSizeBytes", 16);
    private ReLookup<Long> fieldDefaultSizes = new ReLookup();
    private Map<Class<?>, Long> defaultTypeSizes = new HashMap();
    private static volatile Instrumentation globalInstrumentation;

    public static void premain(String agentArgs, Instrumentation inst) {
        globalInstrumentation = inst;
    }

    public static long getObjectSize(Object object) {
        if (globalInstrumentation == null) {
            throw new IllegalStateException("Agent not initialized.");
        }
        return globalInstrumentation.getObjectSize(object);
    }

    public ObjectClassSizer() {
        this.defaultTypeSizes.put(String.class, Long.valueOf(this.defaultStringSizeBytes));
        this.defaultTypeSizes.put(Boolean.TYPE, 1L);
        this.defaultTypeSizes.put(Boolean.class, 2L);
        this.defaultTypeSizes.put(Byte.TYPE, 1L);
        this.defaultTypeSizes.put(Byte.class, 2L);
        this.defaultTypeSizes.put(Character.TYPE, 2L);
        this.defaultTypeSizes.put(Character.class, 4L);
        this.defaultTypeSizes.put(Short.TYPE, 2L);
        this.defaultTypeSizes.put(Short.class, 4L);
        this.defaultTypeSizes.put(Integer.TYPE, 4L);
        this.defaultTypeSizes.put(Integer.class, 8L);
        this.defaultTypeSizes.put(Long.TYPE, 8L);
        this.defaultTypeSizes.put(Long.class, 18L);
        this.defaultTypeSizes.put(Float.TYPE, 4L);
        this.defaultTypeSizes.put(Float.class, 8L);
        this.defaultTypeSizes.put(Double.TYPE, 8L);
        this.defaultTypeSizes.put(Double.class, 16L);
        this.defaultTypeSizes.put(Date.class, 32L);
        this.defaultTypeSizes.put(Void.class, 0L);
        this.defaultTypeSizes.put(BigDecimal.class, 32L);
        this.defaultTypeSizes.put(BigInteger.class, 56L);
    }

    public long sizeInBytes(Class<?> aClass) {
        Field[] fields;
        if (!String.class.equals(aClass) && ClassPath.isPrimitive(aClass)) {
            Long sizeLong = this.defaultTypeSizes.get(aClass);
            return sizeLong;
        }
        if (aClass.isEnum()) {
            ?[] enumConstants = aClass.getEnumConstants();
            long enumEntyrSize = this.defaultTypeSizes.get(Integer.TYPE);
            if (enumConstants == null || enumConstants.length == 0) {
                return enumEntyrSize;
            }
            return enumEntyrSize * (long)enumConstants.length + 1L;
        }
        Long defaultTypeSize = this.defaultTypeSizes.get(aClass);
        if (defaultTypeSize != null) {
            return defaultTypeSize;
        }
        Field[] arr = fields = aClass.getDeclaredFields();
        int len = arr.length;
        long totalSize = 0L;
        for (int i = 0; i < len; ++i) {
            Field field = arr[i];
            String fieldName = field.getName();
            Long fieldNameLengthBytes = this.fieldDefaultSizes.get(fieldName);
            Class<?> fieldClass = field.getType();
            if (fieldNameLengthBytes != null) {
                totalSize += fieldNameLengthBytes.longValue();
                continue;
            }
            if (String.class.equals(fieldClass) || char[].class.equals(fieldClass)) {
                totalSize += (long)this.defaultStringSizeBytes;
                continue;
            }
            if (ClassPath.isPrimitive(fieldClass)) {
                Long sizeLong = this.defaultTypeSizes.get(fieldClass);
                totalSize += sizeLong.longValue();
                continue;
            }
            totalSize += this.sizeInBytes(field.getType());
        }
        return totalSize;
    }

    public int getDefaultStringSizeBytes() {
        return this.defaultStringSizeBytes;
    }

    public void setDefaultStringSizeBytes(int defaultStringSizeBytes) {
        this.defaultStringSizeBytes = defaultStringSizeBytes;
    }

    public ReLookup<Long> getFieldDefaultSizes() {
        return this.fieldDefaultSizes;
    }

    public void setFieldDefaultSizes(ReLookup<Long> fieldDefaultSizes) {
        this.fieldDefaultSizes = fieldDefaultSizes;
    }

    public Map<Class<?>, Long> getDefaultTypeSizes() {
        return this.defaultTypeSizes;
    }

    public void setDefaultTypeSizes(Map<Class<?>, Long> defaultTypeSizes) {
        this.defaultTypeSizes = defaultTypeSizes;
    }

    public static void main(String[] args) {
        UserProfile userProfile = new JavaBeanGeneratorCreator<UserProfile>(UserProfile.class).randomizeAll().create();
        System.out.println("Object type: " + userProfile.getClass() + ", size: " + ObjectClassSizer.getObjectSize(userProfile) + " bytes");
    }
}

