/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.patterns.search.queryService;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.concurrent.Callable;
import nyla.solutions.core.data.DataRow;
import nyla.solutions.core.exception.RequiredException;
import nyla.solutions.core.patterns.expression.BooleanExpression;
import nyla.solutions.core.patterns.iteration.PageCriteria;
import nyla.solutions.core.patterns.iteration.Pagination;
import nyla.solutions.core.patterns.iteration.Paging;
import nyla.solutions.core.patterns.search.queryService.QuestCriteria;
import nyla.solutions.core.patterns.search.queryService.QuestFactory;
import nyla.solutions.core.patterns.search.queryService.QuestFinder;
import nyla.solutions.core.patterns.search.queryService.QuestService;
import nyla.solutions.core.patterns.workthread.ExecutorBoss;
import nyla.solutions.core.util.Organizer;

public class QuestMgr
implements QuestService {
    private final QuestFactory questFactory;
    private final ExecutorBoss executorBoss;

    public QuestMgr(QuestFactory questFactory) {
        this.questFactory = questFactory;
        this.executorBoss = QuestFactory.createExecutorBoss();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Paging<DataRow> search(QuestCriteria questCriteria) throws RequiredException {
        Paging<DataRow> paging;
        block19: {
            if (questCriteria == null) {
                throw new RequiredException("questCriteria");
            }
            String[] dataSources = questCriteria.getDataSources();
            if (dataSources == null || dataSources.length == 0) {
                throw new RequiredException("questCriteria.dataSources");
            }
            String questName = questCriteria.getQuestName();
            if (questName == null || questName.length() == 0) {
                throw new RequiredException("questCriteria.questName");
            }
            PageCriteria pageCriteria = questCriteria.getPageCriteria();
            if (pageCriteria != null) {
                if (pageCriteria.getSize() <= 0) {
                    throw new RequiredException("Page Criteria must be greater than zero");
                }
                if (pageCriteria.isSavePagination()) {
                    this.questFactory.getPagination(pageCriteria).clear();
                }
            }
            ArrayList finders = new ArrayList(dataSources.length);
            try {
                for (String dataSource : dataSources) {
                    finders.add(this.questFactory.createFinder(questCriteria, dataSource));
                }
                Collection dataRowCollection = this.executorBoss.startWorking(finders);
                Comparator<DataRow> comparator = null;
                String sorter = questCriteria.getSort();
                if (sorter != null) {
                    comparator = this.questFactory.createComparator(sorter);
                }
                BooleanExpression<DataRow> filterExpression = null;
                String filter = questCriteria.getFilter();
                if (filter != null) {
                    filterExpression = this.questFactory.createBooleanExpression(filter);
                }
                paging = Organizer.flattenPaging(dataRowCollection, comparator, filterExpression);
                if (finders == null) break block19;
                finders.trimToSize();
                if (finders.isEmpty()) break block19;
            }
            catch (Throwable throwable) {
                if (finders != null) {
                    finders.trimToSize();
                    if (!finders.isEmpty()) {
                        for (Callable callable : finders) {
                            if (callable == null) continue;
                            try {
                                ((QuestFinder)callable).dispose();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
                throw throwable;
            }
            for (Callable finder : finders) {
                if (finder == null) continue;
                try {
                    ((QuestFinder)finder).dispose();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return paging;
    }

    @Override
    public long count(PageCriteria pageCriteria) {
        Pagination pagination = this.questFactory.getPagination(pageCriteria);
        if (pagination == null) {
            return 0L;
        }
        return pagination.count(pageCriteria);
    }

    @Override
    public Paging<DataRow> getPaging(PageCriteria pageCriteria) {
        Paging<DataRow> dataRows = this.questFactory.getPagination(pageCriteria).getPaging(pageCriteria);
        return dataRows;
    }
}

