/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.security.data;

import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import nyla.solutions.core.security.data.AccessControl;
import nyla.solutions.core.security.data.Permission;
import nyla.solutions.core.security.data.SecurityPermission;

public class SecurityAccessControl
implements Serializable,
AccessControl {
    private Principal principal;
    private List<Permission> permissions = new ArrayList<Permission>(10);
    private boolean negative = false;
    static final long serialVersionUID = 1L;

    public SecurityAccessControl(Principal principal) {
        this.principal = principal;
    }

    public SecurityAccessControl() {
        this.principal = null;
        this.negative = false;
    }

    public SecurityAccessControl(Principal principal, Permission permission) {
        if (principal == null) {
            throw new IllegalArgumentException("principal is required");
        }
        if (permission == null) {
            throw new IllegalArgumentException("permission is required");
        }
        this.principal = principal;
        this.permissions.add(permission);
    }

    public SecurityAccessControl(Principal principal, boolean negative, String permission) {
        this(principal, permission);
        this.negative = negative;
    }

    public SecurityAccessControl(Principal principal, String permission) {
        this(principal, new SecurityPermission(permission));
    }

    @Override
    public boolean addPermission(Permission permission) {
        if (this.permissions.contains(permission)) {
            return false;
        }
        return this.permissions.add(permission);
    }

    @Override
    public void addPermissions(Collection<Permission> aPermssions) {
        if (aPermssions == null) {
            throw new IllegalArgumentException("aPermssions required in SecurityAccessControl");
        }
        Iterator<Permission> i = aPermssions.iterator();
        while (i.hasNext()) {
            this.addPermission((SecurityPermission)i.next());
        }
    }

    @Override
    public boolean removePermission(Permission permission) {
        return this.permissions.remove(permission);
    }

    @Override
    public boolean checkPermission(Permission permission) {
        if (permission == null) {
            return false;
        }
        boolean authorized = false;
        for (Permission accessPermission : this.permissions) {
            if (!accessPermission.isAuthorized(permission)) continue;
            authorized = true;
            break;
        }
        if (this.negative) {
            return !authorized;
        }
        return authorized;
    }

    @Override
    public synchronized List<Permission> getPermissions() {
        if (this.permissions == null || this.permissions.isEmpty()) {
            return null;
        }
        return new ArrayList<Permission>(this.permissions);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("SecurityAccessControl [principal=").append(this.principal).append(", permissions=").append(this.permissions).append(", negative=").append(this.negative).append("]");
        return builder.toString();
    }

    @Override
    public void setNegativePermissions() {
        this.negative = true;
    }

    @Override
    public boolean isNegative() {
        return this.negative;
    }

    @Override
    public Principal getPrincipal() {
        return this.principal;
    }

    @Override
    public synchronized void setPermissions(Collection<Permission> aPermissions) {
        this.permissions.clear();
        if (aPermissions == null || aPermissions.isEmpty()) {
            return;
        }
        ArrayList<Permission> set = new ArrayList<Permission>(aPermissions);
        this.permissions = set;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.permissions == null ? 0 : this.permissions.hashCode());
        result = 31 * result + (this.principal == null ? 0 : this.principal.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SecurityAccessControl other = (SecurityAccessControl)obj;
        if (this.permissions == null ? other.permissions != null : !this.permissions.equals(other.permissions)) {
            return false;
        }
        return !(this.principal == null ? other.principal != null : !this.principal.equals(other.principal));
    }

    public boolean setPrincipal(Principal principal) {
        this.principal = principal;
        return true;
    }
}

