/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.security.user.conversion;

import java.util.Set;
import java.util.stream.Collectors;
import nyla.solutions.core.patterns.conversion.Converter;
import nyla.solutions.core.patterns.conversion.TextToEmailsConverter;
import nyla.solutions.core.security.user.data.UserProfile;

public class TextEmailsToUserProfilesConverter
implements Converter<String, Set<UserProfile>> {
    private final TextToEmailsConverter converter = new TextToEmailsConverter();

    @Override
    public Set<UserProfile> convert(String text) {
        Set<String> emails = this.converter.convert(text);
        if (emails == null) {
            return null;
        }
        return emails.stream().map(email -> new UserProfile((String)email, null, null, null)).collect(Collectors.toSet());
    }
}

