/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.security.user.conversion;

import java.util.HashMap;
import java.util.function.BiConsumer;
import nyla.solutions.core.operations.ClassPath;
import nyla.solutions.core.patterns.conversion.Converter;
import nyla.solutions.core.security.user.data.UserProfile;

public class VcfStringToUserProfileConverter
implements Converter<String, UserProfile> {
    private Class<? extends UserProfile> userProfileClass = UserProfile.class;
    private HashMap<String, BiConsumer<String, UserProfile>> strategies = new HashMap();

    public VcfStringToUserProfileConverter() {
        BiConsumer<String, UserProfile> setEmail = (vcfLine, userProfile) -> {
            int atIndex = vcfLine.lastIndexOf(":");
            String email = vcfLine.substring(atIndex + 1);
            if (email != null) {
                email = email.trim();
            }
            userProfile.setEmail(email);
        };
        this.strategies.put("email", setEmail);
        BiConsumer<String, UserProfile> setName = (vcfLine, userProfile) -> {
            int atIndex = vcfLine.lastIndexOf(":");
            String name = vcfLine.substring(atIndex + 1);
            if (name == null || name.trim().length() == 0) {
                return;
            }
            String[] tokens = name.split(";");
            if (tokens.length > 0 && tokens[0] != null && tokens[0].trim().length() > 0) {
                userProfile.setLastName(tokens[0]);
            }
            if (tokens.length > 1 && tokens[1] != null && tokens[1].trim().length() > 0) {
                userProfile.setFirstName(tokens[1]);
            }
        };
        this.strategies.put("n", setName);
        BiConsumer<String, UserProfile> setFirstName = (vcfLine, userProfile) -> {
            int atIndex = vcfLine.lastIndexOf(":");
            String name = vcfLine.substring(atIndex + 1);
            if (name == null || name.trim().length() == 0) {
                return;
            }
            String previousFirstName = userProfile.getFirstName();
            if (previousFirstName == null || previousFirstName.trim().length() == 0) {
                userProfile.setFirstName(name);
            }
        };
        this.strategies.put("fn", setFirstName);
    }

    @Override
    public UserProfile convert(String text) {
        if (text == null || text.trim().length() == 0) {
            return null;
        }
        String[] lines = text.split("\\\n");
        BiConsumer<String, UserProfile> strategy = null;
        UserProfile userProfile = null;
        String lineUpper = null;
        for (String line : lines) {
            int index = line.indexOf(";");
            if (index < 0) continue;
            String term = line.substring(0, index);
            strategy = this.strategies.get(term.toLowerCase());
            lineUpper = line.toUpperCase();
            if (strategy == null) {
                if (lineUpper.startsWith("N:")) {
                    strategy = this.strategies.get("n");
                } else if (lineUpper.startsWith("FN:")) {
                    strategy = this.strategies.get("fn");
                } else {
                    if (!lineUpper.contains("EMAIL;")) continue;
                    strategy = this.strategies.get("email");
                }
            }
            if (userProfile == null) {
                userProfile = (UserProfile)ClassPath.newInstance(this.userProfileClass);
            }
            strategy.accept(line, userProfile);
        }
        return userProfile;
    }

    public Class<? extends UserProfile> getUserProfileClass() {
        return this.userProfileClass;
    }

    public void setUserProfileClass(Class<? extends UserProfile> userProfileClass) {
        this.userProfileClass = userProfileClass;
    }
}

