/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.security.user.data;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import nyla.solutions.core.data.Copier;
import nyla.solutions.core.data.Criteria;
import nyla.solutions.core.security.user.data.User;
import nyla.solutions.core.util.Text;

public class UserProfile
extends Criteria
implements User,
Copier,
Comparable<Object> {
    private String email = "";
    private String loginID = "";
    private String firstName = "";
    private String lastName = "";
    private String title = "";
    private String phone;
    static final long serialVersionUID = UserProfile.class.getName().hashCode();

    @Override
    public UserProfile clone() throws CloneNotSupportedException {
        return (UserProfile)super.clone();
    }

    @Override
    public String getFirstName() {
        return this.firstName;
    }

    public UserProfile() {
    }

    public UserProfile(String email, String loginID, String firstName, String lastName) {
        this.email = email;
        this.loginID = loginID;
        this.firstName = firstName;
        this.lastName = lastName;
    }

    @Override
    public String getLastName() {
        return this.lastName;
    }

    @Override
    public String getName() {
        StringBuilder name = new StringBuilder();
        if (this.lastName != null && this.lastName.length() > 0) {
            name.append(this.lastName);
        }
        if (name.length() > 0) {
            name.append(", ");
        }
        if (this.firstName != null && this.firstName.length() > 0) {
            name.append(this.firstName);
        }
        return name.toString();
    }

    public void setLastName(String lastName) throws IllegalArgumentException {
        if (Text.isNull(lastName)) {
            return;
        }
        this.lastName = lastName;
    }

    public void setFirstName(String firstName) throws IllegalArgumentException {
        if (Text.isNull(firstName)) {
            return;
        }
        if (!this.firstName.equals(firstName)) {
            this.firstName = firstName;
        }
    }

    @Override
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        if (Text.isNull(email)) {
            return;
        }
        this.email = email;
    }

    @Override
    public int compareTo(Object object) {
        if (!(object instanceof User)) {
            return -1;
        }
        User user = (User)object;
        return this.getLastName().compareTo(user.getLastName());
    }

    public static Collection<User> sortByLastName(Collection<User> aUsers) {
        if (!(aUsers instanceof List)) {
            return null;
        }
        List l = (List)aUsers;
        Collections.sort(l);
        return l;
    }

    @Override
    public String getLoginID() {
        return this.loginID;
    }

    public void setLoginID(String loginID) {
        if (loginID == null) {
            loginID = "";
        }
        this.loginID = loginID;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        if (title == null) {
            title = "";
        }
        this.title = title;
    }

    @Override
    public void copy(Copier from) {
        super.copy(from);
        if (!(from instanceof UserProfile)) {
            return;
        }
        UserProfile other = (UserProfile)from;
        this.email = other.email;
        this.loginID = other.loginID;
        this.firstName = other.firstName;
        this.lastName = other.lastName;
        this.title = other.title;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.email == null ? 0 : this.email.hashCode());
        result = 31 * result + (this.firstName == null ? 0 : this.firstName.hashCode());
        result = 31 * result + (this.lastName == null ? 0 : this.lastName.hashCode());
        result = 31 * result + (this.loginID == null ? 0 : this.loginID.hashCode());
        result = 31 * result + (this.title == null ? 0 : this.title.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UserProfile other = (UserProfile)obj;
        if (this.email == null ? other.email != null : !this.email.equals(other.email)) {
            return false;
        }
        if (this.firstName == null ? other.firstName != null : !this.firstName.equals(other.firstName)) {
            return false;
        }
        if (this.lastName == null ? other.lastName != null : !this.lastName.equals(other.lastName)) {
            return false;
        }
        if (this.loginID == null ? other.loginID != null : !this.loginID.equals(other.loginID)) {
            return false;
        }
        return !(this.title == null ? other.title != null : !this.title.equals(other.title));
    }

    @Override
    public void setId(String id) {
        this.setLoginID(id);
    }

    @Override
    public String getId() {
        return this.getLoginID();
    }

    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }
}

