/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.util;

import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import nyla.solutions.core.data.clock.Day;
import nyla.solutions.core.exception.ConfigException;
import nyla.solutions.core.exception.ConfigLockException;
import nyla.solutions.core.patterns.observer.SubjectObserver;
import nyla.solutions.core.util.Text;
import nyla.solutions.core.util.settings.ConfigSettings;
import nyla.solutions.core.util.settings.Settings;

public class Config {
    private static final ReentrantLock lock = new ReentrantLock();
    public static final String RESOURCE_BUNDLE_NAME = "config";
    public static final String SYS_PROPERTY = "config.properties";
    public static final String DEFAULT_PROP_FILE_NAME = "config.properties";
    private static Settings settings = null;
    private static final long lockPeriodMs = 3000L;

    public static String interpret(String property) {
        return Config.getSettings().interpret(property);
    }

    public static void setAlwaysReload(boolean alwaysReload) {
        Config.getSettings().setAlwaysReload(alwaysReload);
    }

    public static void reLoad() {
        Config.getSettings().reLoad();
    }

    public static String getLocation() {
        return System.getProperty("java.io.tmpdir");
    }

    public static String getTempDir() {
        return System.getProperty("java.io.tmpdir");
    }

    public static String getProperty(String key) {
        return Config.getSettings().getProperty(key);
    }

    public static String[] getPropertyStrings(String key) {
        return Config.getSettings().getPropertyStrings(key);
    }

    public static String[] getPropertyStrings(Class<?> aClass, String key) {
        return Text.split(Config.getProperty(aClass, key));
    }

    public static String[] getPropertyStrings(Class<?> aClass, String key, String aDefault) {
        return Config.getSettings().getPropertyStrings(aClass, key, aDefault);
    }

    public static String getProperty(Class<?> aClass, String key, ResourceBundle resourceBundle) {
        return Config.getSettings().getProperty(aClass, key, resourceBundle);
    }

    public static String[] getPropertyStrings(Class<?> aClass, String key, String ... aDefault) {
        return Config.getSettings().getPropertyStrings(aClass, key, aDefault);
    }

    public static String getProperty(Class<?> aClass, String key) {
        return Config.getSettings().getProperty(aClass, key);
    }

    public static String getProperty(Class<?> aClass, String key, String aDefault) {
        return Config.getSettings().getProperty(aClass, key, aDefault);
    }

    public static String getPropertyEnv(String key) {
        String env = Config.sanitizeEnvVarNAme(key);
        return Config.getProperty(env);
    }

    public static String getPropertyEnv(String key, String aDefault) {
        String env = Config.sanitizeEnvVarNAme(key);
        return Config.getProperty(env, aDefault);
    }

    public static String sanitizeEnvVarNAme(String key) {
        String env = Text.replaceForRegExprWith(key, "[-\\. ]", "_").toUpperCase();
        return env;
    }

    public static String getProperty(String key, String aDefault) {
        return Config.getSettings().getProperty(key, aDefault);
    }

    public static Integer getPropertyInteger(Class<?> aClass, String key, int defaultValue) {
        return Config.getSettings().getPropertyInteger(key, defaultValue);
    }

    public static Character getPropertyCharacter(Class<?> aClass, String key, char defaultValue) {
        return Config.getSettings().getPropertyCharacter(aClass, key, defaultValue);
    }

    public static Integer getPropertyInteger(String key) {
        return Config.getSettings().getPropertyInteger(key);
    }

    public static Integer getPropertyInteger(String key, int aDefault) {
        return Config.getSettings().getPropertyInteger(key, aDefault);
    }

    public static Double getPropertyDouble(Class<?> cls, String key) {
        return Config.getSettings().getPropertyDouble(cls, key);
    }

    public static Double getPropertyDouble(Class<?> aClass, String key, double defaultValue) {
        return Config.getSettings().getPropertyDouble(key, defaultValue);
    }

    public static Double getPropertyDouble(String key) {
        return Config.getSettings().getPropertyDouble(key);
    }

    public static Double getPropertyDouble(String key, double aDefault) {
        return Config.getPropertyDouble(key, (Double)aDefault);
    }

    public static Double getPropertyDouble(String key, Double aDefault) {
        return Config.getSettings().getPropertyDouble(key, aDefault);
    }

    public static Integer getPropertyInteger(Class<?> cls, String key) {
        return Config.getSettings().getPropertyInteger(cls, key);
    }

    public static Integer getPropertyInteger(Class<?> cls, String key, Integer aDefault) {
        return Config.getSettings().getPropertyInteger(cls, key, aDefault);
    }

    public static Integer getPropertyInteger(String key, Integer aDefault) {
        return Config.getSettings().getPropertyInteger(key, aDefault);
    }

    public static Boolean getPropertyBoolean(String key) {
        return Config.getSettings().getPropertyBoolean(key);
    }

    public static Boolean getPropertyBoolean(String key, Boolean aBool) {
        return Config.getSettings().getPropertyBoolean(key, aBool);
    }

    public static Boolean getPropertyBoolean(Class<?> aClass, String key, boolean aBool) {
        return Config.getSettings().getPropertyBoolean(aClass, key, aBool);
    }

    public static Boolean getPropertyBoolean(String key, boolean aBool) {
        return Config.getSettings().getPropertyBoolean(key, aBool);
    }

    public static Long getPropertyLong(String key) {
        return Config.getSettings().getPropertyLong(key);
    }

    public static Long getPropertyLong(Class<?> aClass, String key, long aDefault) {
        return Config.getSettings().getPropertyLong(aClass, key, aDefault);
    }

    public static Long getPropertyLong(Class<?> aClass, String key) {
        return Config.getSettings().getPropertyLong(aClass, key);
    }

    public static Long getPropertyLong(String key, long aDefault) {
        return Config.getSettings().getPropertyLong(key, aDefault);
    }

    public static Long getPropertyLong(String key, Long aDefault) {
        return Config.getSettings().getPropertyLong(key, aDefault);
    }

    public static char[] getPropertyPassword(String key) {
        return Config.getSettings().getPropertyPassword(key);
    }

    public static Day getDay(String key) {
        return new Day(Config.getProperty(key));
    }

    public static char[] getPropertyPassword(String key, char ... defaultPassword) {
        return Config.getSettings().getPropertyPassword(key, defaultPassword);
    }

    public static char[] getPropertyPassword(String key, String defaultPassword) {
        return Config.getSettings().getPropertyPassword(key, defaultPassword);
    }

    public static char[] getPropertyPassword(Class<?> aClass, String key, char[] defaultPassword) {
        return Config.getSettings().getPropertyPassword(aClass, key, defaultPassword);
    }

    public static Map<Object, Object> getProperties() {
        return Config.getSettings().getProperties();
    }

    public static void setProperties(Properties properties) {
        block6: {
            try {
                if (lock.tryLock(3000L, TimeUnit.MILLISECONDS)) {
                    try {
                        Config.getSettings().setProperties(properties);
                        break block6;
                    }
                    finally {
                        lock.unlock();
                    }
                }
                throw new ConfigLockException("Setting properties");
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public static String getUserDir() {
        return System.getProperty("user.dir");
    }

    public static String getFileSeparator() {
        return System.getProperty("file.separator");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Settings getSettings() {
        if (!lock.tryLock(3000L, TimeUnit.MILLISECONDS)) throw new ConfigLockException("Get settings");
        try {
            if (settings == null) {
                settings = new ConfigSettings();
            }
            Settings settings = Config.settings;
            lock.unlock();
            return settings;
        }
        catch (Throwable throwable) {
            try {
                lock.unlock();
                throw throwable;
            }
            catch (InterruptedException e) {
                throw new ConfigException(e);
            }
        }
    }

    public static void setSettings(Settings theSettings) {
        try {
            if (lock.tryLock(3000L, TimeUnit.MILLISECONDS)) {
                if (theSettings == null) {
                    throw new IllegalArgumentException("theSettings is required");
                }
            } else {
                throw new ConfigLockException("Setting settings");
            }
            settings = theSettings;
        }
        catch (InterruptedException e) {
            throw new ConfigException(e);
        }
    }

    public static String getPropertyEnv(String key, Map<?, ?> properties) {
        String value = null;
        if (properties != null && (value = (String)properties.get(key)) != null) {
            return value.toString();
        }
        value = Config.getPropertyEnv(key, "");
        String text = value.toString();
        if (text.length() == 0) {
            return null;
        }
        return text;
    }

    public static void registerObserver(SubjectObserver<Settings> settingsObserver) {
        Config.getSettings().registerObserver(settingsObserver);
    }

    public static Day getPropertyDay(String key) {
        return new Day(Config.getProperty(key));
    }

    public static Settings loadArgs(String[] args) {
        return Config.getSettings().loadArgs(args);
    }

    public static String getPropertyEnv(String key, Properties properties, String defaultValue) {
        String value = Config.getPropertyEnv(key, properties);
        if (value == null || value.length() == 0) {
            return defaultValue;
        }
        return value;
    }

    public static <T> Class<T> getPropertyClass(String propertyKey) {
        return Config.getSettings().getPropertyClass(propertyKey);
    }

    public static <T> Class<T> getPropertyClass(String propertyKey, Class<T> defautlClass) {
        return Config.getSettings().getPropertyClass(propertyKey, defautlClass);
    }
}

