/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import nyla.solutions.core.exception.ConfigException;
import nyla.solutions.core.exception.SetupException;
import nyla.solutions.core.operations.ClassPath;
import nyla.solutions.core.operations.logging.Log;
import nyla.solutions.core.operations.logging.SystemOutLog;
import nyla.solutions.core.util.Config;
import nyla.solutions.core.util.JavaBean;

public class Debugger {
    private static boolean DEBUG = Config.getPropertyBoolean(Debugger.class, "DEBUG", true);
    private static Log defaultLogger;
    public static final String LOG_CLASS_NAME_PROP = "Log.class";
    private static Class<?> logClass;
    private static HashMap<Class<?>, Log> logMap;

    public static Log getLog(Class c) {
        try {
            if (c == null || logClass == null) {
                return defaultLogger;
            }
            Log logger = logMap.get(c);
            if (logger == null) {
                logger = (Log)ClassPath.newInstance(logClass);
                logger.setLoggingClass(c);
                logMap.put(c, logger);
            }
            return logger;
        }
        catch (Exception e) {
            e.printStackTrace();
            return defaultLogger;
        }
    }

    public static String stackTrace(Throwable t) {
        if (t == null) {
            return "Debugger.stackTrace(null) NULL EXCEPTION (NO TRACE AVAILABLE)!!";
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        return sw.toString();
    }

    public static String toString(Object obj) {
        return Debugger.toString(obj, new HashSet<Object>());
    }

    private static String toString(Object obj, Set<Object> set) {
        if (obj == null) {
            return "null";
        }
        if (set.contains(obj)) {
            return "";
        }
        set.add(obj);
        if (obj instanceof Object[]) {
            Object[] objs = (Object[])obj;
            StringBuilder arrayText = new StringBuilder("{");
            for (int i = 0; i < objs.length; ++i) {
                arrayText.append("[" + i + "]=").append(Debugger.toString(objs[i], set));
                if (i + 1 == objs.length) continue;
                arrayText.append(" ,");
            }
            arrayText.append("}");
            return arrayText.toString();
        }
        if (obj instanceof String || obj instanceof Integer || obj instanceof StringBuilder) {
            return obj.toString();
        }
        Class<?> cl = obj.getClass();
        StringBuilder r = new StringBuilder(cl.getName());
        do {
            r.append("[");
            AccessibleObject[] fields = cl.getDeclaredFields();
            AccessibleObject.setAccessible(fields, true);
            for (int i = 0; i < fields.length; ++i) {
                AccessibleObject f = fields[i];
                r.append(((Field)f).getName()).append("=");
                try {
                    Object val = ((Field)f).get(obj);
                    if (val != null) {
                        if (val instanceof Object[]) {
                            Object[] objs = (Object[])val;
                            for (int c = 0; c < objs.length; ++c) {
                                r.append(Debugger.toString(objs[c], set));
                            }
                        } else {
                            r.append(val);
                        }
                    } else {
                        r.append("null");
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (i >= fields.length - 1) continue;
                r.append(",");
            }
            r.append("]");
        } while ((cl = cl.getSuperclass()) != Object.class);
        return r.toString();
    }

    public static Map<Object, Object> toMap(Object aObject) {
        try {
            return JavaBean.toMap(aObject);
        }
        catch (Exception e) {
            throw new RuntimeException(Debugger.stackTrace(e));
        }
    }

    public static void dump(Object obj) {
        Debugger.println("DUMP:" + Debugger.toString(obj));
    }

    public static void println(Object caller, Object message) {
        if (!DEBUG) {
            return;
        }
        StringBuilder text = new StringBuilder();
        Class<?> c = Debugger.callerBuilder(caller, text);
        if (message instanceof Throwable) {
            Debugger.getLog(c).debug(text.append(Debugger.stackTrace((Throwable)message)));
        } else {
            Debugger.getLog(c).debug(text.append(message));
        }
    }

    public void setDoDebug(boolean willDebug) {
        DEBUG = willDebug;
    }

    public static void println(Object message) {
        if (!DEBUG) {
            return;
        }
        Debugger.getLog(Debugger.class).debug(message);
    }

    public static void printError(Object caller, Object message) {
        StringBuilder text = new StringBuilder();
        Class<?> c = Debugger.callerBuilder(caller, text);
        if (message instanceof Throwable) {
            Debugger.getLog(c).error(text.append(Debugger.stackTrace((Throwable)message)));
        } else {
            Debugger.getLog(c).error(text.append(message));
        }
    }

    public static void printError(Object errorMessage) {
        if (errorMessage instanceof Throwable) {
            Throwable e = (Throwable)errorMessage;
            Debugger.getLog(Debugger.class).error(Debugger.stackTrace(e));
        } else {
            Debugger.getLog(Debugger.class).error(errorMessage);
        }
    }

    public static void printFatal(Object message) {
        Log log;
        if (message instanceof Throwable) {
            Throwable e = (Throwable)message;
            e.printStackTrace();
        }
        if ((log = Debugger.getLog(Debugger.class)) != null) {
            log.fatal(message);
        } else {
            System.err.println(message);
        }
    }

    public static void printFatal(Object caller, Object message) {
        StringBuilder text = new StringBuilder();
        Class<?> c = Debugger.callerBuilder(caller, text);
        if (message instanceof Throwable) {
            Debugger.getLog(c).fatal(text.append(Debugger.stackTrace((Throwable)message)));
        } else {
            Debugger.getLog(c).fatal(text.append(message));
        }
    }

    public static void printInfo(Object caller, Object message) {
        StringBuilder text = new StringBuilder();
        Class<?> c = Debugger.callerBuilder(caller, text);
        if (message instanceof Throwable) {
            Debugger.getLog(c).info(text.append(Debugger.stackTrace((Throwable)message)));
        } else {
            Debugger.getLog(c).info(text.append(message));
        }
    }

    public static void printInfo(Object message) {
        if (message instanceof Throwable) {
            Throwable e = (Throwable)message;
            Debugger.getLog(Debugger.class).info(Debugger.stackTrace(e));
        } else {
            Debugger.getLog(Debugger.class).info(message);
        }
    }

    public static void printWarn(Object caller, Object message) {
        StringBuilder text = new StringBuilder();
        Class<?> c = Debugger.callerBuilder(caller, text);
        if (message instanceof Throwable) {
            Debugger.getLog(c).warn(text.append(Debugger.stackTrace((Throwable)message)));
        } else {
            Debugger.getLog(c).warn(text.append(message));
        }
    }

    private static Class<?> callerBuilder(Object caller, StringBuilder text) {
        Class<?> c = Debugger.class;
        if (caller != null) {
            if (caller instanceof Class) {
                c = (Class<?>)caller;
                text.append(c.getName()).append(": ");
            } else if (caller instanceof String) {
                text.append(caller).append(": ");
            } else {
                c = caller.getClass();
                text.append(c.getName()).append(": ");
            }
        }
        return c;
    }

    public static void printWarn(Object message) {
        if (message instanceof Throwable) {
            Throwable e = (Throwable)message;
            Debugger.getLog(Debugger.class).warn(Debugger.stackTrace(e));
        } else {
            Debugger.getLog(Debugger.class).warn(message);
        }
    }

    public static void println(Object caller, String format, Object ... args) {
        String msg = String.format(format, args);
        Debugger.println(caller, msg);
    }

    public static void printInfo(Object caller, String format, Object ... args) {
        String msg = String.format(format, args);
        Debugger.printInfo(caller, msg);
    }

    public static void printWarn(Object caller, String format, Object ... args) {
        String msg = String.format(format, args);
        Debugger.printWarn(caller, msg);
    }

    public static void printError(Object caller, String format, Object ... args) {
        String msg = String.format(format, args);
        Debugger.printError(caller, msg);
    }

    public static void printFatal(Object caller, String format, Object ... args) {
        String msg = String.format(format, args);
        Debugger.printFatal(caller, msg);
    }

    static {
        logMap = new HashMap();
        try {
            logClass = Class.forName(Config.getProperty(LOG_CLASS_NAME_PROP, SystemOutLog.class.getName()));
            defaultLogger = (Log)ClassPath.newInstance(logClass);
        }
        catch (SetupException e) {
            throw e;
        }
        catch (ConfigException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new SetupException(e);
        }
        catch (NoClassDefFoundError e) {
            throw new SetupException("Check value of Log.class in confi file" + Config.getLocation(), e);
        }
        catch (ClassNotFoundException e) {
            throw new SetupException("Check value of Log.class in confi file" + Config.getLocation(), e);
        }
    }
}

