/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.util;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import nyla.solutions.core.exception.SystemException;
import nyla.solutions.core.util.Config;
import nyla.solutions.core.util.Debugger;
import nyla.solutions.core.util.Text;

public class Presenter {
    private ResourceBundle resourceBundle = null;

    private Presenter() {
        this(Locale.US);
    }

    private Presenter(Locale aLocale) {
        this(Presenter.class.getName(), aLocale);
    }

    protected Presenter(String aBundleName, Locale aLocale) {
        if (aBundleName == null) {
            throw new IllegalArgumentException("aBundleName required in Presenter");
        }
        if (aLocale == null) {
            throw new IllegalArgumentException("aLocale required in Presenter");
        }
        this.init(ResourceBundle.getBundle(aBundleName, aLocale));
    }

    private Presenter(ResourceBundle aResourceBundle) {
        this.init(aResourceBundle);
    }

    private void init(ResourceBundle aResourceBundle) {
        if (aResourceBundle == null) {
            throw new IllegalArgumentException("aResourceBundle required in Presenter.init");
        }
        this.resourceBundle = aResourceBundle;
    }

    public static Presenter getPresenter(ResourceBundle bundle) {
        return new Presenter(bundle);
    }

    public static Presenter getPresenter() {
        return new Presenter();
    }

    public static Presenter getPresenter(Locale aLocale) {
        return new Presenter(aLocale);
    }

    public static Presenter getPresenter(Class<?> aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException("aClass required in Presenter.getPresenter");
        }
        return new Presenter(ResourceBundle.getBundle(aClass.getName()));
    }

    public String getText(String aKey) {
        String defaultMessage = "";
        try {
            defaultMessage = this.resourceBundle.getString(aKey);
        }
        catch (MissingResourceException e) {
            Debugger.printWarn(e);
        }
        return Config.getProperty(aKey, defaultMessage);
    }

    public <K, V> String getText(String key, Map<K, V> parameters) {
        try {
            return Text.format(this.getText(key), parameters);
        }
        catch (Exception e) {
            throw new SystemException(e);
        }
    }

    public String getText(String key, String[] values) {
        if (values == null) {
            throw new IllegalArgumentException("aValues required in Presenter.getText");
        }
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            for (int i = 0; i < values.length; ++i) {
                map.put(Integer.toString(i), values[i]);
            }
            return this.getText(key, map);
        }
        catch (Exception e) {
            throw new SystemException(e);
        }
    }

    public String[] getTexts(String propertyName, String textsSplitRegEx) {
        String text = this.getText(propertyName);
        return text.split(textsSplitRegEx);
    }
}

