/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.util.settings;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nyla.solutions.core.util.Text;

public class ArgsParser {
    public static Map<Object, Object> parse(String[] args) {
        if (args == null || args.length == 0) {
            return null;
        }
        return ArgsParser.parse(Arrays.asList(args));
    }

    public static Map<Object, Object> parse(List<String> args) {
        boolean START = true;
        int VAL = 2;
        int state = 1;
        HashMap<Object, Object> map = new HashMap<Object, Object>(args.size());
        String key = null;
        String value = null;
        block4: for (String arg : args) {
            arg = arg.trim();
            switch (state) {
                case 1: {
                    if (arg.startsWith("-")) {
                        arg = Text.replaceForRegExprWith(arg, "^-*", "");
                    }
                    if (arg.contains("=")) {
                        String[] tokens = Text.splitRE(arg, "=");
                        if (tokens.length != 2) continue block4;
                        key = tokens[0];
                        value = tokens[1];
                        map.put(key, ArgsParser.formatValue(value));
                        state = 1;
                        break;
                    }
                    key = arg;
                    state = 2;
                    break;
                }
                case 2: {
                    map.put(key, ArgsParser.formatValue(arg));
                    state = 1;
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown message:");
                }
            }
        }
        return map;
    }

    private static String formatValue(String value) {
        if (value == null) {
            return "";
        }
        if ((value = value.trim()).startsWith("\"") || value.startsWith("'")) {
            value = value.substring(1);
        }
        if (value.endsWith("\"") || value.endsWith("'")) {
            value = value.substring(0, value.length() - 1);
        }
        return value;
    }
}

