/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.data;

import nyla.solutions.core.data.Copier;
import nyla.solutions.core.data.Numbered;
import nyla.solutions.core.data.Property;

public class NumberedProperty
extends Property<String, Integer>
implements Comparable<Object>,
Copier,
Numbered {
    static final long serialVersionUID = NumberedProperty.class.getName().hashCode();

    public NumberedProperty(String name, Integer value) {
        super(name, value);
    }

    public NumberedProperty(int number) {
        super(null, number);
    }

    @Override
    public int compareTo(Object aOther) {
        NumberedProperty other = (NumberedProperty)aOther;
        int comparedName = other.getName().compareTo(this.getName());
        if (comparedName != 0) {
            return comparedName;
        }
        Integer othernumber = other.getValueInteger();
        return Integer.compare(this.getValueInteger(), othernumber);
    }

    @Override
    public void copy(Copier aFrom) {
        if (aFrom == null) {
            throw new IllegalArgumentException("aFrom required in NumberedProperty.copy");
        }
        if (!(aFrom instanceof NumberedProperty)) {
            throw new IllegalArgumentException("aFrom instanceof NumberedProperty required in NumberedProperty.copy");
        }
        NumberedProperty numberedProperty = (NumberedProperty)aFrom;
        this.setValue((Integer)numberedProperty.getValue());
        this.setName(numberedProperty.getName());
        this.setNumber(numberedProperty.getNumber());
    }

    void setName(String name) {
    }

    public NumberedProperty() {
    }

    @Override
    public int getNumber() {
        Object value = this.getValue();
        if (value == null) {
            return 0;
        }
        if (value instanceof String && ((String)value).length() == 0) {
            return 0;
        }
        Integer v = Integer.valueOf(((Integer)this.getValue()).toString());
        if (v == null) {
            return 0;
        }
        return v;
    }

    public void setNumber(int number) {
        this.setValue(number);
    }
}

