/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.data;

import java.io.Serializable;
import nyla.solutions.core.data.Attribute;
import nyla.solutions.core.data.Copier;
import nyla.solutions.core.data.Mappable;
import nyla.solutions.core.util.Text;

public class Property<Key, Value extends Serializable>
implements Serializable,
Mappable<Key, Value>,
Comparable<Object>,
Cloneable,
Copier,
Attribute<Key, Value> {
    private Value value;
    private Key key;
    static final long serialVersionUID = Property.class.getName().hashCode();

    public Property() {
    }

    public Property(Key key, Value value) {
        this.key = key;
        this.value = value;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public int compareTo(Object other) {
        Property otherProperty = (Property)other;
        if (this.key == null) {
            return -1;
        }
        String name = this.getName();
        int compare = name.compareTo(otherProperty.getName());
        if (compare == 0) {
            Object value = this.getValue();
            if (!(value instanceof Comparable)) {
                return compare;
            }
            return ((Comparable)value).compareTo(otherProperty.getValue());
        }
        return compare;
    }

    @Override
    public String getName() {
        return Text.toString(this.key);
    }

    @Override
    public Value getValue() {
        return this.value;
    }

    public void setValue(Value value) {
        this.value = value;
    }

    @Override
    public Key getKey() {
        return this.key;
    }

    @Override
    public void copy(Copier aFrom) {
        if (!(aFrom instanceof Property)) {
            throw new IllegalArgumentException("aFrom instanceof aFrom required in Property.copy");
        }
        Property from = (Property)aFrom;
        this.key = from.key;
        this.value = from.value;
    }

    public boolean equalsValueIgnoreCase(Object aValue) {
        return String.valueOf(this.value).equalsIgnoreCase(String.valueOf(aValue));
    }

    public Integer getValueInteger() {
        String textValue = String.valueOf(this.value);
        if (Text.isInteger(textValue)) {
            return Integer.valueOf(textValue);
        }
        return null;
    }

    public void setKey(Key key) {
        if (key == null) {
            throw new IllegalArgumentException("key required in Property.setKey");
        }
        this.key = key;
    }

    public String getTextValue() {
        return (String)this.getValue();
    }
}

