/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.data.expiration;

import java.time.LocalDateTime;
import java.util.concurrent.ConcurrentHashMap;
import nyla.solutions.core.data.expiration.ExpiringItem;
import nyla.solutions.core.util.Config;

public class ExpiringKeyValueLookup<K, V> {
    private static int INIT_SIZE = Config.settings().getPropertyInteger((Class<?>)ExpiringKeyValueLookup.class, "INIT_SIZE", 20);
    private ConcurrentHashMap<K, ExpiringItem<V>> map = new ConcurrentHashMap(INIT_SIZE);
    private final long expirationMilliseconds;
    private long maxSize = 0L;

    private ExpiringKeyValueLookup(long expirationMilliseconds) {
        this.expirationMilliseconds = expirationMilliseconds;
    }

    public static <K, V> ExpiringKeyValueLookup<K, V> withExpirationMS(long milliseconds) {
        return new ExpiringKeyValueLookup<K, V>(milliseconds);
    }

    public V getValue(K key) {
        ExpiringItem<V> i = this.map.get(key);
        if (i == null) {
            return null;
        }
        if (i.isExpired()) {
            this.map.remove(key);
        }
        return i.value();
    }

    public void putEntry(K key, V value) {
        if (this.maxSize > 0L && this.size() >= this.maxSize) {
            this.map.remove(((ConcurrentHashMap.KeySetView)this.map.keySet()).iterator().next());
        }
        ExpiringItem<V> i = new ExpiringItem<V>(value, LocalDateTime.now().plusNanos(1000000L * this.expirationMilliseconds));
        this.map.put(key, i);
    }

    public long getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(long maxSize) {
        this.maxSize = maxSize;
    }

    public long size() {
        return this.map.size();
    }
}

