/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.exception.fault;

import java.util.HashMap;
import java.util.Map;
import nyla.solutions.core.exception.ConfigException;
import nyla.solutions.core.exception.ConnectionException;
import nyla.solutions.core.exception.SetupException;
import nyla.solutions.core.exception.SystemException;
import nyla.solutions.core.exception.fault.FaultError;
import nyla.solutions.core.exception.fault.FaultException;
import nyla.solutions.core.exception.fault.FaultService;
import nyla.solutions.core.util.Config;
import nyla.solutions.core.util.Debugger;

public class FaultMgr
implements FaultService {
    private Map<String, FaultError> faultErrorMap = null;
    private String lineNumberNotePrefix = Config.settings().getProperty(FaultMgr.class, "lineNumberNotePrefix", "Line number ");
    private String defaultModule = Config.settings().getProperty(FaultMgr.class, "defaultModule", "");
    private String defaultOperation = Config.settings().getProperty(FaultMgr.class, "defaultOperation", "");

    public FaultMgr() {
        this.init();
    }

    @Override
    public FaultException raise(Throwable e) {
        return this.raise(e, null);
    }

    @Override
    public FaultException raise(Throwable e, Object argument) {
        Debugger.println(e);
        if (e instanceof FaultException) {
            FaultException faultException = (FaultException)e;
            this.constructFault(faultException, argument);
            return faultException;
        }
        SystemException faultException = new SystemException(e);
        FaultError faultError = this.faultErrorMap.get(e.getClass().getName());
        if (faultError != null) {
            faultException.setCategory(faultError.getCategory());
            faultException.setCode(faultError.getCode());
        }
        this.constructFault(faultException, argument);
        return faultException;
    }

    public void constructFault(FaultException faultException, Object argument) {
        if (argument != null && faultException.getArgument() == null) {
            faultException.setArgument(argument);
        }
        StackTraceElement stackTraceElement = null;
        if (faultException.getModule() == null) {
            if (this.defaultModule != null && this.defaultModule.length() > 0) {
                faultException.setModule(this.defaultModule);
            } else {
                stackTraceElement = FaultMgr.determineCauseStackTraceElementsn(faultException);
                if (stackTraceElement != null) {
                    faultException.setModule(stackTraceElement.getFileName());
                }
            }
        }
        if (faultException.getOperation() == null) {
            if (this.defaultOperation != null && this.defaultOperation.length() > 0) {
                faultException.setOperation(this.defaultOperation);
            } else {
                if (stackTraceElement == null) {
                    stackTraceElement = FaultMgr.determineCauseStackTraceElementsn(faultException);
                }
                if (stackTraceElement != null) {
                    faultException.setOperation(stackTraceElement.getMethodName());
                }
                if ((faultException.getNotes() == null || faultException.getNotes().length() == 0) && stackTraceElement != null) {
                    faultException.setNotes(this.lineNumberNotePrefix + stackTraceElement.getLineNumber());
                }
            }
        }
    }

    public static StackTraceElement determineCauseStackTraceElementsn(Throwable e) {
        if (e.getCause() != null) {
            return FaultMgr.determineCauseStackTraceElementsn(e.getCause());
        }
        StackTraceElement[] stackTraceElements = e.getStackTrace();
        if (stackTraceElements == null || stackTraceElements.length == 0) {
            return null;
        }
        return stackTraceElements[0];
    }

    private void init() {
        this.faultErrorMap = new HashMap<String, FaultError>();
        this.faultErrorMap.put(SetupException.class.getName(), new FaultError("SUP00", "SETUP"));
        this.faultErrorMap.put(ConnectionException.class.getName(), new FaultError("SUP00", "SETUP"));
        this.faultErrorMap.put(ConfigException.class.getName(), new FaultError("SUP00", "SETUP"));
    }

    public Map<String, FaultError> getFaultErrorMap() {
        return this.faultErrorMap;
    }

    public void setFaultErrorMap(Map<String, FaultError> faultErrorMap) {
        this.faultErrorMap = faultErrorMap;
    }

    public String getDefaultModule() {
        return this.defaultModule;
    }

    public void setDefaultModule(String defaultModule) {
        this.defaultModule = defaultModule;
    }

    public String getDefaultOperation() {
        return this.defaultOperation;
    }

    public void setDefaultOperation(String defaultOperation) {
        this.defaultOperation = defaultOperation;
    }

    public String getLineNumberNotePrefix() {
        return this.lineNumberNotePrefix;
    }

    public void setLineNumberNotePrefix(String lineNumberNotePrefix) {
        this.lineNumberNotePrefix = lineNumberNotePrefix;
    }
}

