/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.io;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Timer;
import java.util.TimerTask;
import nyla.solutions.core.io.FileEvent;
import nyla.solutions.core.io.IO;
import nyla.solutions.core.io.WildCardFilter;
import nyla.solutions.core.patterns.observer.Topic;
import nyla.solutions.core.util.Config;

public class FileMonitor
extends Topic<FileEvent> {
    public static final String TOPIC_NM = "FILE_MONITOR";
    private Timer timer;
    private final long pollingInterval;
    private final long delayMs;

    public FileMonitor(long pollingInterval, long delayMs) {
        super(TOPIC_NM);
        this.pollingInterval = pollingInterval;
        this.delayMs = delayMs;
        this.timer = new Timer(true);
    }

    public synchronized void stop() {
        this.timer.cancel();
    }

    public static void waitFor(File aFile) {
        long previousSize;
        if (aFile == null) {
            return;
        }
        String path = aFile.getAbsolutePath();
        long currentSize = previousSize = IO.getFileSize(path);
        long sleepTime = Config.settings().getPropertyLong("file.monitor.file.wait.time", 100L);
        while (true) {
            try {
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            currentSize = IO.getFileSize(path);
            if (currentSize == previousSize) {
                return;
            }
            previousSize = currentSize;
        }
    }

    public synchronized void monitor(String directory, String fileNameFilter, boolean processCurrentFiles) {
        this.timer.schedule((TimerTask)new FileMonitorNotifier(this, directory, fileNameFilter, processCurrentFiles), this.delayMs, this.pollingInterval);
    }

    protected synchronized void notifyChange(File file) {
        System.out.println("Notify change file=" + file.getAbsolutePath());
        this.notify(FileEvent.createChangedEvent(file));
    }

    protected synchronized void notifyAdd(File file) {
        System.out.println("Notify added file=" + file.getAbsolutePath());
        this.notify(FileEvent.createAddedEvent(file));
    }

    protected long getDelayMs() {
        return this.delayMs;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FileMonitor that = (FileMonitor)o;
        return this.pollingInterval == that.pollingInterval && this.delayMs == that.delayMs && Objects.equals(this.timer, that.timer);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.timer, this.pollingInterval, this.delayMs);
    }

    public long getPollingInterval() {
        return this.pollingInterval;
    }

    private static class FileMonitorNotifier
    extends TimerTask {
        private Hashtable<File, Object> fileLastModifyTimeMap = new Hashtable();
        private FilenameFilter filter = null;
        private File directory = null;
        private FileMonitor fileMonitor = null;

        FileMonitorNotifier(FileMonitor aFileMonitor, String aDirectory, String aFileFilter, boolean processCurrentFiles) {
            if (aDirectory == null || aDirectory.length() == 0) {
                throw new IllegalArgumentException("Directory to minotor has not provided.");
            }
            this.directory = new File(aDirectory);
            if (!this.directory.isDirectory()) {
                throw new IllegalArgumentException("Invalid directory \"" + aDirectory + "\" provided!");
            }
            if (aFileMonitor == null) {
                throw new IllegalArgumentException("FileMonitor not provided");
            }
            this.fileMonitor = aFileMonitor;
            this.filter = new WildCardFilter(aFileFilter);
            if (!processCurrentFiles) {
                this.init();
            }
        }

        private void init() {
            File[] files = this.directory.listFiles(this.filter);
            if (files == null) {
                return;
            }
            File file = null;
            for (int i = 0; i < files.length; ++i) {
                file = files[i];
                this.fileLastModifyTimeMap.put(file, file.lastModified());
            }
        }

        @Override
        public void run() {
            try {
                if (this.directory == null) {
                    return;
                }
                File[] filesInDir = this.directory.listFiles(this.filter);
                if (filesInDir == null) {
                    return;
                }
                File dirfile = null;
                Long lastModifiedTime = null;
                long newModifiedTime = 0L;
                ArrayList<String> processedFiles = new ArrayList<String>();
                for (int i = 0; i < filesInDir.length; ++i) {
                    dirfile = filesInDir[i];
                    if (processedFiles.contains(dirfile.getAbsolutePath())) continue;
                    lastModifiedTime = (Long)this.fileLastModifyTimeMap.get(dirfile);
                    if (lastModifiedTime == null) {
                        this.fileMonitor.notifyAdd(dirfile);
                    } else {
                        long l = newModifiedTime = dirfile.exists() ? dirfile.lastModified() : -1L;
                        if (newModifiedTime != lastModifiedTime) {
                            this.fileMonitor.notifyChange(dirfile);
                        }
                    }
                    this.fileLastModifyTimeMap.put(dirfile, dirfile.lastModified());
                    processedFiles.add(dirfile.getAbsolutePath());
                }
                List<File> filesInDirList = Arrays.asList(filesInDir);
                File fileInMap = null;
                Map.Entry<File, Object> mapEntry = null;
                Iterator<Map.Entry<File, Object>> i = this.fileLastModifyTimeMap.entrySet().iterator();
                while (i.hasNext()) {
                    try {
                        mapEntry = i.next();
                        fileInMap = mapEntry.getKey();
                        if (filesInDirList.contains(fileInMap)) continue;
                        System.out.println("File was removed " + fileInMap.getName());
                        i.remove();
                        System.out.println("DONE");
                    }
                    catch (ConcurrentModificationException concurrentModificationException) {}
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

