/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.io;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import nyla.solutions.core.exception.RequiredException;
import nyla.solutions.core.io.FileTokenizer;
import nyla.solutions.core.io.IO;
import nyla.solutions.core.util.Config;

public class FolderFileTokenizer {
    private ArrayList<FileTokenizer> fileList = null;
    private String listFilter = Config.settings().getProperty(this.getClass(), "listFilter", "*.*");
    private File folder = null;

    public Collection<FileTokenizer> getFileTokenizer() {
        return this.fileList;
    }

    public void setFolder(File folder) {
        if (folder == null) {
            throw new RequiredException("folder in FolderFileTokenizer");
        }
        if (!folder.isDirectory()) {
            throw new RequiredException("valid folder " + folder.getAbsolutePath());
        }
        this.folder = folder;
        File[] files = IO.listFiles(this.folder, this.listFilter);
        this.fileList = new ArrayList(files.length);
        for (int i = 0; i < files.length; ++i) {
            this.fileList.add(new FileTokenizer(files[i]));
        }
    }

    public String getListFilter() {
        return this.listFilter;
    }

    public void setListFilter(String listFilter) {
        this.listFilter = listFilter;
    }

    public File getFolder() {
        return this.folder;
    }
}

