/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import nyla.solutions.core.data.Data;
import nyla.solutions.core.exception.RequiredException;
import nyla.solutions.core.exception.SystemException;
import nyla.solutions.core.io.FolderFilter;
import nyla.solutions.core.io.IOFileOperation;
import nyla.solutions.core.io.WildCardFilter;
import nyla.solutions.core.util.Config;
import nyla.solutions.core.util.Debugger;
import nyla.solutions.core.util.Text;

public class IO {
    public static final String CHARSET_NM = Config.settings().getProperty(IO.class, "CHARSET", "UTF-8");
    public static final Charset CHARSET = Charset.forName(CHARSET_NM);
    public static final String DEFAULT_FILE_NM_INVALID_CHARACTERS_RE = "\\/|\\\\|:|\"|\\*|\\?|<|>|\\|";
    public static final String BYTE_BUFFER_SIZE_PROP = "byte.buffer.size";
    public static final int FILE_IO_BATCH_SIZE = 1024;
    public static final String NEWLINE = System.getProperty("line.separator");

    public static synchronized Date touch(File file) throws IOException {
        return IO.touch(file, Calendar.getInstance().getTime());
    }

    public static synchronized Date touch(File file, Date date) throws IOException {
        if (date == null) {
            date = Calendar.getInstance().getTime();
        }
        if (!file.exists()) {
            FileOutputStream fs = new FileOutputStream(file);
            fs.close();
        } else if (!file.setLastModified(date.getTime())) {
            throw new IOException("Could not update time");
        }
        return date;
    }

    public static List<File> find(Collection<String> filePaths, String pattern) {
        if (filePaths == null) {
            return null;
        }
        ArrayList<File> results = new ArrayList<File>(filePaths.size());
        WildCardFilter filter = new WildCardFilter(pattern);
        for (String filePath : filePaths) {
            File file = Paths.get(filePath, new String[0]).toFile();
            List<File> nested = IO.find(file, filter);
            if (nested == null || nested.isEmpty()) continue;
            results.addAll(nested);
        }
        if (results.isEmpty()) {
            return null;
        }
        results.trimToSize();
        return results;
    }

    public static List<File> find(File file, WildCardFilter filter) {
        if (!file.exists()) {
            return null;
        }
        ArrayList<File> results = new ArrayList<File>();
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            if (fileArray == null || fileArray.length == 0) {
                return null;
            }
            for (File nestedFile : fileArray) {
                List<File> nesultedResults = IO.find(nestedFile, filter);
                if (nesultedResults == null) continue;
                results.addAll(nesultedResults);
            }
        } else if (filter.accept(file, file.getName())) {
            results.add(file);
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }

    public static Map<File, Collection<String>> grep(String text, List<File> logFiles) throws IOException {
        if (logFiles == null || logFiles.isEmpty()) {
            return null;
        }
        HashMap<File, Collection<String>> map = new HashMap<File, Collection<String>>();
        for (File file : logFiles) {
            if (!file.exists()) {
                throw new IllegalArgumentException("File:" + file.getAbsolutePath() + " does not exist");
            }
            ArrayList<String> matches = new ArrayList<String>();
            BufferedReader reader = Files.newBufferedReader(file.toPath(), StandardCharsets.UTF_8);
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    if (!line.contains(text)) continue;
                    matches.add(line);
                }
                if (matches.isEmpty()) continue;
                map.put(file, matches);
            }
            finally {
                if (reader == null) continue;
                reader.close();
            }
        }
        if (map.isEmpty()) {
            return null;
        }
        return map;
    }

    public static String fileSperator() {
        return System.getProperty("file.separator");
    }

    public static String readText(BufferedReader bufferedReader) throws IOException {
        String text;
        if (bufferedReader == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        while ((text = bufferedReader.readLine()) != null) {
            builder.append(text).append(IO.newline());
        }
        return builder.toString();
    }

    public static void serializeToFile(Object obj, File file) {
        ObjectOutputStream stream = null;
        try {
            stream = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
            stream.writeObject(obj);
        }
        catch (Exception e) {
            throw new SystemException(Debugger.stackTrace(e));
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static byte[] serializeToBytes(Object obj) {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            byte[] byArray;
            try (ObjectOutputStream stream = new ObjectOutputStream(new BufferedOutputStream(out));){
                stream.writeObject(obj);
                stream.flush();
                byArray = out.toByteArray();
            }
            return byArray;
        }
        catch (Exception e) {
            throw new SystemException(Debugger.stackTrace(e));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T deserialize(File file) {
        try (ObjectInputStream stream = new ObjectInputStream(new FileInputStream(file));){
            Object object = stream.readObject();
            return (T)object;
        }
        catch (Exception e) {
            throw new SystemException(Debugger.stackTrace(e));
        }
    }

    public static void mergeFiles(File output, File ... filesToMerge) throws IOException {
        if (output == null || filesToMerge == null || filesToMerge.length == 0) {
            return;
        }
        Path outFile = output.toPath();
        try (FileChannel out = FileChannel.open(outFile, StandardOpenOption.CREATE, StandardOpenOption.WRITE);){
            for (int i = 0; i < filesToMerge.length; ++i) {
                Path inFile = filesToMerge[i].toPath();
                try (FileChannel in = FileChannel.open(inFile, StandardOpenOption.READ);){
                    if (in == null) continue;
                    long lineNumberSize = in.size();
                    for (long p = 0L; p < lineNumberSize; p += in.transferTo(p, lineNumberSize - p, out)) {
                    }
                    continue;
                }
            }
        }
    }

    public static boolean mkdir(File folder) {
        if (folder == null || folder.exists()) {
            return false;
        }
        File parent = folder.getParentFile();
        if (parent != null && !parent.exists()) {
            IO.mkdir(parent);
        }
        return folder.mkdir();
    }

    public static File[] listFolders(File folder) {
        if (folder == null) {
            return null;
        }
        if (!folder.isDirectory()) {
            throw new RequiredException(folder.getAbsolutePath() + " is not a folder");
        }
        return folder.listFiles(new FolderFilter());
    }

    public static boolean delete(File file) throws IOException {
        if (file == null) {
            throw new RequiredException("file");
        }
        if (!file.exists()) {
            return false;
        }
        if (file.isDirectory()) {
            return IO.deleteFolder(file);
        }
        return file.delete();
    }

    public static boolean exists(String aFilePath) {
        if (aFilePath == null) {
            throw new IllegalArgumentException("aFilePath required in IO.exists");
        }
        File file = new File(aFilePath);
        return file.exists();
    }

    public static void writeFile(File file, byte[] data) throws IOException {
        IO.writeFile(file.getAbsolutePath(), data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeProperties(String filePath, Properties properties) throws IOException {
        Writer writer = null;
        try {
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(filePath), CHARSET);
            properties.store(writer, filePath);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties readProperties(String filePath) throws IOException {
        Reader reader = null;
        Properties properties = new Properties();
        try {
            reader = new InputStreamReader((InputStream)new FileInputStream(filePath), CHARSET);
            properties.load(reader);
            Properties properties2 = properties;
            return properties2;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception e) {
                    Debugger.printWarn(e);
                }
            }
        }
    }

    public static String readFile(File file) throws IOException {
        if (file == null) {
            throw new RequiredException("file to read");
        }
        if (!file.exists()) {
            throw new RequiredException("file must exist " + file.getAbsolutePath());
        }
        return IO.readFile(file.getAbsolutePath());
    }

    public static String readText(InputStream inputStream, boolean closeInputStream) throws IOException {
        return IO.readText(inputStream, closeInputStream, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readText(InputStream inputStream, boolean closeInputStream, int limit) throws IOException {
        Reader reader = null;
        try {
            reader = IO.toReader(inputStream);
            BufferedReader buffreader = new BufferedReader(new InputStreamReader(inputStream, CHARSET));
            String tmp = buffreader.readLine();
            if (tmp == null) {
                String string = null;
                return string;
            }
            StringBuilder line = new StringBuilder(tmp);
            while (tmp != null) {
                line.append("\n");
                tmp = buffreader.readLine();
                if (tmp != null) {
                    line.append(tmp);
                }
                if (limit <= 0 || line.length() <= limit) continue;
                String string = line.toString();
                return string;
            }
            String string = line.toString();
            return string;
        }
        finally {
            if (closeInputStream) {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (Exception exception) {}
                }
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    public static String newline() {
        return NEWLINE;
    }

    public static void copyDirectory(File sourceFolder, File destinationFolder) throws IOException {
        if (sourceFolder == null || !sourceFolder.isDirectory()) {
            throw new RequiredException("sourceFolder");
        }
        if (destinationFolder == null) {
            throw new RequiredException("destinationFolder");
        }
        if (!destinationFolder.exists()) {
            IO.mkdir(destinationFolder);
        }
        if (!destinationFolder.isDirectory()) {
            throw new RequiredException("destinationFile.isDirectory() in IO");
        }
        File[] sourceNestedFiles = sourceFolder.listFiles();
        if (sourceNestedFiles == null) {
            return;
        }
        for (int i = 0; i < sourceNestedFiles.length; ++i) {
            if (sourceNestedFiles[i].isFile()) {
                IO.copy(sourceNestedFiles[i], destinationFolder.getAbsolutePath());
                continue;
            }
            IO.copyDirectory(sourceNestedFiles[i], new File(destinationFolder.getAbsolutePath() + File.separator + sourceNestedFiles[i].getName()));
        }
    }

    public static void copyDirectory(String source, String destination, String pattern) throws IOException {
        File destinationFile = new File(destination);
        if (!destinationFile.exists()) {
            Debugger.println(IO.class, "mkdir:" + destinationFile.mkdir());
        }
        if (!destinationFile.isDirectory()) {
            throw new RequiredException("destinationFile \"" + destinationFile + "\" is must a directory");
        }
        File sourceFile = new File(source);
        File[] sourceNestedFiles = IO.listFiles(sourceFile, pattern);
        for (int i = 0; i < sourceNestedFiles.length; ++i) {
            if (sourceNestedFiles[i].isFile()) {
                IO.copy(sourceNestedFiles[i], destinationFile.getAbsolutePath());
                continue;
            }
            IO.copyDirectory(sourceNestedFiles[i].getAbsolutePath(), destinationFile.getAbsolutePath() + File.separator + sourceNestedFiles[i].getName(), pattern);
        }
    }

    public static String formatFileName(String aFileName) {
        if (aFileName == null || aFileName.length() == 0) {
            return "";
        }
        String invalidCharRE = Config.settings().getProperty(IO.class.getName() + ".formatFile.invalidCharRE", DEFAULT_FILE_NM_INVALID_CHARACTERS_RE);
        String replaceText = Config.settings().getProperty(IO.class.getName() + ".formatFile.replaceText", "");
        return Text.replaceForRegExprWith(aFileName, invalidCharRE, replaceText);
    }

    protected static String readFully(Reader aReader) throws IOException {
        if (aReader == null) {
            throw new IllegalArgumentException("aReader required in IO.readFully");
        }
        BufferedReader buffreader = new BufferedReader(aReader);
        String tmp = buffreader.readLine();
        if (tmp == null || tmp.length() == 0) {
            return null;
        }
        StringBuffer line = new StringBuffer(tmp);
        while (tmp != null) {
            tmp = buffreader.readLine();
            if (tmp == null) continue;
            line.append("\n").append(tmp);
        }
        return line.toString();
    }

    private static byte[] readBinary(InputStream inputStream) throws IOException {
        int len;
        if (inputStream == null) {
            throw new IllegalArgumentException("inputStream is required");
        }
        byte[] bytes = new byte[1024];
        ByteArrayOutputStream ba = new ByteArrayOutputStream(1024);
        while ((len = inputStream.read(bytes)) > 0) {
            ba.write(bytes, 0, len);
        }
        return ba.toByteArray();
    }

    public static String readClassPath(String path) throws IOException {
        ClassLoader classLoader = IO.getDefaultClassLoader();
        InputStream is = classLoader != null ? classLoader.getResourceAsStream(path) : ClassLoader.getSystemResourceAsStream(path);
        if (is == null) {
            throw new FileNotFoundException(path + " cannot be opened because it does not exist");
        }
        return IO.readFully(new InputStreamReader(is, CHARSET));
    }

    public static byte[] readBinaryClassPath(String path) throws IOException {
        ClassLoader classLoader = IO.getDefaultClassLoader();
        InputStream is = classLoader != null ? classLoader.getResourceAsStream(path) : ClassLoader.getSystemResourceAsStream(path);
        if (is == null) {
            throw new FileNotFoundException(path + " cannot be opened because it does not exist");
        }
        return IO.readBinary(is);
    }

    public static ClassLoader getDefaultClassLoader() {
        ClassLoader cl = null;
        try {
            cl = Thread.currentThread().getContextClassLoader();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (cl == null && (cl = IO.class.getClassLoader()) == null) {
            try {
                cl = ClassLoader.getSystemClassLoader();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return cl;
    }

    public static File[] listFiles(String location, String pattern) {
        return IO.listFiles(new File(location), pattern);
    }

    public static String[] list(String location, String pattern) {
        return IO.list(new File(location), pattern);
    }

    public static File[] listFiles(String location) {
        if (location == null || location.length() == 0) {
            throw new RequiredException("location in IO");
        }
        File folder = new File(location);
        return IO.listFiles(folder);
    }

    public static File[] listFiles(File folder) {
        if (folder == null) {
            return null;
        }
        if (!folder.isDirectory()) {
            throw new RequiredException(folder.getAbsolutePath() + " is not a directory");
        }
        return folder.listFiles();
    }

    public static String[] list(File directory, String pattern) {
        if (pattern == null) {
            return directory.list();
        }
        WildCardFilter filter = IO.createFilter(directory, pattern);
        return directory.list(filter);
    }

    public static Set<File> listFileRecursive(String dir, String pattern) {
        if (dir == null || dir.length() == 0) {
            dir = ".";
        }
        return IO.listFileRecursive(Paths.get(dir, new String[0]).toFile(), pattern);
    }

    public static Set<File> listFileRecursive(File directory, String pattern) {
        File[] folders;
        File[] files = IO.listFiles(directory, pattern);
        HashSet<File> set = new HashSet<File>(1024);
        if (files != null && files.length > 0) {
            set.addAll(Arrays.asList(files));
        }
        if ((folders = IO.listFolders(directory)) != null && folders.length > 0) {
            for (File folder : folders) {
                Set<File> nested = IO.listFileRecursive(folder, pattern);
                if (nested == null) continue;
                set.addAll(nested);
            }
        }
        if (set.isEmpty()) {
            return null;
        }
        return set;
    }

    public static File[] listFiles(File directory, String pattern) {
        if (pattern == null || pattern.length() == 0) {
            return null;
        }
        IO.validateDirectory(directory);
        int indexofSlash = pattern.indexOf("/");
        if (indexofSlash > 0) {
            String suffix = pattern.substring(0, indexofSlash);
            pattern = pattern.substring(indexofSlash + 1);
            directory = new File(directory.getAbsolutePath() + "/" + suffix);
            IO.validateDirectory(directory);
        }
        WildCardFilter filter = IO.createFilter(directory, pattern);
        return directory.listFiles(filter);
    }

    private static WildCardFilter createFilter(File directory, String pattern) {
        if (pattern == null || pattern.length() == 0) {
            throw new IllegalArgumentException("pattern required in list");
        }
        return new WildCardFilter(pattern);
    }

    private static void validateDirectory(File directory) {
        if (directory == null) {
            throw new RequiredException("directory in IO.list");
        }
        if (!directory.exists()) {
            throw new IllegalArgumentException("Directory does not exist " + directory.getAbsolutePath());
        }
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException("Must provide a directory " + directory.getAbsolutePath());
        }
    }

    public static String readURL(String urlAddress) throws IOException {
        if (urlAddress == null) {
            throw new RequiredException("url in IO.readURL");
        }
        try (Reader reader = null;){
            URL url = new URL(urlAddress);
            URLConnection connection = url.openConnection();
            reader = IO.toReader(connection.getInputStream());
            String string = IO.readFully(reader);
            return string;
        }
    }

    public static String fixPath(String aPath) {
        if (aPath == null || aPath.length() == 0) {
            throw new IllegalArgumentException("aPath required in Documentum.fixPath");
        }
        aPath = aPath.replace('\\', '/');
        return aPath;
    }

    public static long getFileSize(String aFilePath) throws IllegalArgumentException {
        if (aFilePath == null) {
            throw new IllegalArgumentException("Cannot obtain file size, File Path not provided");
        }
        return new File(aFilePath).length();
    }

    public static Map readMap(String aFilePath) throws IOException, FileNotFoundException {
        InputStream in = IO.getFileInputStream(aFilePath);
        Properties prop = new Properties();
        prop.load(in);
        return prop;
    }

    public static byte[] readBinaryFile(File aFile, int aRetryCount, long aRetryDelayMS) throws IOException {
        for (int i = 0; i <= aRetryCount; ++i) {
            try {
                return IO.readBinaryFile(aFile);
            }
            catch (Exception e) {
                try {
                    Thread.sleep(aRetryDelayMS);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                continue;
            }
        }
        throw new IOException(aFile.getAbsolutePath());
    }

    public static byte[] readBinaryFile(String aFilePath) throws FileNotFoundException, IOException {
        return IO.readBinaryFile(new File(aFilePath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readBinaryFile(File file) throws FileNotFoundException, IOException {
        BufferedInputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(file));
            byte[] b = new byte[Long.valueOf(file.length()).intValue()];
            int cnt = in.read(b);
            if (cnt <= 0) {
                byte[] byArray = null;
                return byArray;
            }
            byte[] byArray = b;
            return byArray;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static String readFile(String aFilePath, int aRetryCount, long aRetryDelayMS, Charset charset) throws IOException {
        for (int i = 0; i <= aRetryCount; ++i) {
            try {
                return IO.readFile(aFilePath, charset);
            }
            catch (Exception e) {
                try {
                    Thread.sleep(aRetryDelayMS);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                continue;
            }
        }
        throw new IOException(aFilePath);
    }

    public static String readFile(String fileName) throws IOException {
        return IO.readFile(fileName, CHARSET);
    }

    public static String readFile(String fileName, Charset charSet) throws IOException {
        if (fileName == null || fileName.length() == 0) {
            return null;
        }
        Path path = Paths.get(fileName, new String[0]);
        File file = path.toFile();
        if (!file.exists()) {
            throw new IllegalArgumentException("File:" + file.getAbsolutePath() + " does not exist");
        }
        StringBuilder stringBuilder = new StringBuilder(Long.valueOf(file.length()).intValue());
        boolean firstTime = true;
        try (BufferedReader reader = Files.newBufferedReader(path, charSet);){
            String line;
            while ((line = reader.readLine()) != null) {
                if (!firstTime) {
                    stringBuilder.append(NEWLINE);
                }
                firstTime = false;
                stringBuilder.append(line);
            }
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] readLines(String aFileNM, Charset charset) throws IOException {
        if (Data.isNull(aFileNM)) {
            throw new IllegalArgumentException("file name not provided");
        }
        ArrayList<String> lines = new ArrayList<String>();
        BufferedReader buffreader = null;
        try {
            buffreader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(aFileNM), charset));
            String tmp = buffreader.readLine();
            if (tmp == null) {
                throw new IOException(aFileNM + " empty file");
            }
            lines.add(tmp);
            while (tmp != null) {
                tmp = buffreader.readLine();
                if (tmp == null) continue;
                lines.add(tmp);
            }
            String[] lineArray = new String[lines.size()];
            lines.toArray(lineArray);
            String[] stringArray = lineArray;
            return stringArray;
        }
        finally {
            if (buffreader != null) {
                try {
                    buffreader.close();
                }
                catch (Exception e) {
                    Debugger.printWarn(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(File aFile, String aDestinationPath) throws FileNotFoundException, IOException {
        InputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(aFile));
            IO.write(aDestinationPath + File.separator + aFile.getName(), in);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(String fileName, URL url) throws Exception {
        FileOutputStream os = null;
        InputStream is = null;
        try {
            int cnt;
            os = new FileOutputStream(fileName);
            is = url.openStream();
            int BYTE_BUFFER_SIZE = Config.settings().getPropertyInteger(BYTE_BUFFER_SIZE_PROP, 1024);
            byte[] bytes = new byte[BYTE_BUFFER_SIZE];
            while ((cnt = is.read(bytes)) != -1) {
                ((OutputStream)os).write(bytes, 0, cnt);
            }
        }
        finally {
            if (os != null) {
                try {
                    ((OutputStream)os).close();
                }
                catch (Exception exception) {}
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static IOFileOperation ops(File file) {
        return new IOFileOperation(file);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T deserialize(byte[] bytes) {
        try (ObjectInputStream stream = new ObjectInputStream(new ByteArrayInputStream(bytes));){
            Object object = stream.readObject();
            return (T)object;
        }
        catch (Exception e) {
            throw new RuntimeException(Debugger.stackTrace(e));
        }
    }

    public static File tempDirFile() {
        return Paths.get(IO.tempDir(), new String[0]).toFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readInputStream(InputStream aInputStream) throws IOException {
        try (Reader reader = null;){
            reader = IO.toReader(aInputStream);
            String string = IO.readFully(reader);
            return string;
        }
    }

    public static void write(OutputStream aOutputStream, InputStream aInputStream) throws IOException {
        int cnt;
        int BYTE_BUFFER_SIZE = Config.settings().getPropertyInteger(BYTE_BUFFER_SIZE_PROP, 1024);
        byte[] bytes = new byte[BYTE_BUFFER_SIZE];
        while ((cnt = aInputStream.read(bytes)) != -1) {
            aOutputStream.write(bytes, 0, cnt);
        }
    }

    public static void write(Writer aOutputStream, Reader aInputStream) throws IOException {
        int cnt;
        int BYTE_BUFFER_SIZE = Config.settings().getPropertyInteger(BYTE_BUFFER_SIZE_PROP, 1024);
        char[] chars = new char[BYTE_BUFFER_SIZE];
        while ((cnt = aInputStream.read(chars)) != -1) {
            aOutputStream.write(chars, 0, cnt);
        }
    }

    public static Reader toReader(InputStream aInputStream) {
        return new InputStreamReader(aInputStream, CHARSET);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(String aFilePath, InputStream aInputStream) throws IOException {
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(aFilePath);
            IO.write(os, aInputStream);
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static InputStream getFileInputStream(String aFilePath) throws FileNotFoundException {
        return new FileInputStream(aFilePath);
    }

    public static String hideExtension(String aFileName) {
        if (aFileName == null || aFileName.length() == 0) {
            throw new IllegalArgumentException("File Name required in IO hideExtension");
        }
        int lastPeriodIndex = aFileName.lastIndexOf(".");
        if (lastPeriodIndex > -1) {
            return aFileName.substring(0, lastPeriodIndex);
        }
        return aFileName;
    }

    public static String parseFileExtension(String aFileName) {
        if (aFileName == null) {
            throw new IllegalArgumentException("aFileName required in parseFileExtension");
        }
        int len = aFileName.length();
        if (len == 0) {
            throw new IllegalArgumentException("aFileName required in parseFileExtension");
        }
        int lastPeriodIndex = aFileName.lastIndexOf(".");
        if (lastPeriodIndex > -1) {
            return aFileName.substring(lastPeriodIndex + 1, len);
        }
        return null;
    }

    public static String parseFolderPath(String filePath) {
        if (filePath == null || filePath.length() == 0) {
            throw new RequiredException("filePath");
        }
        File file = new File(filePath);
        return file.getParentFile().getAbsolutePath();
    }

    public static String parseFileName(String aFolderPath) {
        int lastSeparatorIndex;
        int lastFSIndex = aFolderPath.lastIndexOf("/");
        int lastBSIndex = aFolderPath.lastIndexOf("\\");
        if (lastBSIndex > (lastSeparatorIndex = lastFSIndex)) {
            lastSeparatorIndex = lastBSIndex;
        }
        if (lastSeparatorIndex > -1) {
            return aFolderPath.substring(lastSeparatorIndex + 1);
        }
        return aFolderPath;
    }

    public static void writeFile(String filePath, byte[] data) throws IOException {
        IO.writeFile(filePath, data, false);
    }

    public static void writeFile(String aFilePath, byte[] aData, boolean append) throws IOException {
        if (aData == null) {
            throw new IOException("No bytes provided for file " + aFilePath);
        }
        if (aFilePath == null || aFilePath.length() == 0) {
            throw new IllegalArgumentException("aFilePath required in writeFile");
        }
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(aFilePath, append);
            ((OutputStream)os).write(aData);
            os.flush();
        }
        catch (FileNotFoundException e) {
            throw new IOException(Debugger.stackTrace(e) + " path=" + aFilePath);
        }
        finally {
            if (os != null) {
                try {
                    ((OutputStream)os).close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static void writeFile(String fileName, String text) throws IOException {
        IO.writeFile(fileName, text, CHARSET);
    }

    public static void writeFile(String fileName, String text, Charset charset) throws IOException {
        IO.writeFile(fileName, text, false, charset);
    }

    public static void writeFile(String fileName, String text, boolean append) throws IOException {
        IO.writeFile(fileName, text, append, CHARSET);
    }

    public static void writeFile(String fileName, String text, boolean append, Charset charset) throws IOException {
        IO.writeFile(new File(fileName), text, append, charset);
    }

    public static void writeFile(File file, String text) throws IOException {
        IO.writeFile(file, text, CHARSET);
    }

    public static void writeFile(File file, String text, Charset charset) throws IOException {
        IO.writeFile(file, text, false, charset);
    }

    public static void writeFile(File file, String text, boolean append) throws IOException {
        IO.writeFile(file, text, append, CHARSET);
    }

    public static void writeFile(File file, String text, boolean append, Charset charset) throws IOException {
        if (text == null) {
            return;
        }
        IO.mkdir(file.getParentFile());
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file, append), charset.newEncoder());){
            writer.write(text);
        }
    }

    public static void writeAppend(String fileName, String data) throws IOException {
        IO.writeAppend(fileName, data, CHARSET);
    }

    public static void writeAppend(File file, String data) throws IOException {
        IO.writeFile(file, data, true, CHARSET);
    }

    public static void writeAppend(String fileName, String data, Charset charset) throws IOException {
        IO.writeFile(new File(fileName), data, true, charset);
    }

    private static boolean deleteFolder(File file) throws IOException {
        IO.emptyFolder(file);
        return file.delete();
    }

    public static void emptyFolder(File directory) throws IOException {
        File[] files = directory.listFiles();
        if (files != null && files.length > 0) {
            for (int i = 0; i < files.length; ++i) {
                IO.delete(files[i]);
            }
        }
    }

    public static void mkdir(String directory) throws IOException {
        if (directory == null || directory.length() == 0) {
            return;
        }
        IO.mkdir(Paths.get(directory, new String[0]).toFile());
    }

    public static String tempDir() {
        return System.getProperty("java.io.tmpdir");
    }
}

