/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.io;

import java.io.File;
import java.nio.file.Path;

public class IOFileOperation {
    private final File file;

    public IOFileOperation(File file) {
        if (file == null) {
            throw new NullPointerException("file provided is null");
        }
        this.file = file;
    }

    public void deleteDirectoryFiles() {
        if (!this.file.isDirectory()) {
            return;
        }
        File[] files = this.file.listFiles();
        if (files == null) {
            return;
        }
        for (File nestedFile : files) {
            nestedFile.delete();
        }
    }

    public File mkParentDir() {
        Path parent = this.file.toPath().getParent();
        parent.toFile().mkdir();
        return parent.toFile();
    }
}

