/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.io;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Hashtable;
import java.util.Map;
import nyla.solutions.core.io.IO;

public final class SynchronizedIO {
    private Map<String, Object> lockMap = new Hashtable<String, Object>();
    private static SynchronizedIO instance = null;

    private SynchronizedIO() {
    }

    public static synchronized SynchronizedIO getInstance() {
        if (instance == null) {
            instance = new SynchronizedIO();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String aFilePath, InputStream aInputStream) throws IOException {
        Object lock;
        Object object = lock = this.retrieveLock(aFilePath);
        synchronized (object) {
            IO.write(aFilePath, aInputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeAppend(String fileName, String data) throws IOException {
        Object lock;
        Object object = lock = this.retrieveLock(fileName);
        synchronized (object) {
            IO.writeAppend(fileName, data, IO.CHARSET);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeFile(String filePath, byte[] data) throws IOException {
        Object lock;
        Object object = lock = this.retrieveLock(filePath);
        synchronized (object) {
            IO.writeFile(filePath, data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeFile(String aFilePath, byte[] aData, boolean append) throws IOException {
        Object lock;
        Object object = lock = this.retrieveLock(aFilePath);
        synchronized (object) {
            IO.writeFile(aFilePath, aData, append);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeFile(String aFileName, String aData) throws IOException {
        Object lock;
        Object object = lock = this.retrieveLock(aFileName);
        synchronized (object) {
            IO.writeFile(aFileName, aData, IO.CHARSET);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeFile(String aFileName, URL aData) throws Exception {
        Object lock;
        Object object = lock = this.retrieveLock(aFileName);
        synchronized (object) {
            IO.writeFile(aFileName, aData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readFile(String filePath) throws IOException {
        Object lock;
        Object object = lock = this.retrieveLock(filePath);
        synchronized (object) {
            return IO.readFile(filePath);
        }
    }

    public synchronized void clearLocks() {
        this.lockMap.clear();
    }

    private Object retrieveLock(String key) {
        Object lock = this.lockMap.get(key);
        if (lock == null) {
            lock = key;
            this.lockMap.put(key, lock);
        }
        return lock;
    }
}

