/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.io.csv;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import nyla.solutions.core.exception.FormatException;
import nyla.solutions.core.io.csv.CsvSelectBuilder;
import nyla.solutions.core.io.csv.formulas.CsvFormula;

public class CsvReader
implements Iterable<List<String>> {
    private final ArrayList<List<String>> data;

    public CsvSelectBuilder selectBuilder() {
        return new CsvSelectBuilder(this);
    }

    protected List<List<String>> getData() {
        return this.data;
    }

    public CsvReader(Reader reader) throws IOException {
        this.data = new ArrayList(10);
        try (BufferedReader r = new BufferedReader(reader);){
            String line = null;
            while ((line = r.readLine()) != null) {
                this.data.add(CsvReader.parse(line));
            }
        }
    }

    public CsvReader(File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("file is required");
        }
        if (!file.exists()) {
            throw new IllegalArgumentException("File:" + file.getAbsolutePath() + " does not exist");
        }
        String line = null;
        this.data = new ArrayList();
        try (BufferedReader reader = Files.newBufferedReader(file.toPath(), StandardCharsets.UTF_8);){
            while ((line = reader.readLine()) != null) {
                this.data.add(CsvReader.parse(line));
            }
        }
    }

    public Stream<List<String>> stream() {
        return this.data.stream();
    }

    @Override
    public Iterator<List<String>> iterator() {
        return this.data.listIterator();
    }

    public <T> T get(int row, int col, DataType dataType) {
        List<String> rowList = this.row(row);
        if (rowList == null || rowList.isEmpty() || col >= rowList.size()) {
            return this.nullFor(dataType);
        }
        String cell = rowList.get(col);
        T results = this.toType(cell, dataType);
        return results;
    }

    private <T> T nullFor(DataType dataType) {
        switch (dataType) {
            case Long: {
                return (T)Long.valueOf(-1L);
            }
        }
        return null;
    }

    private <T> T toType(String cell, DataType dataType) {
        switch (dataType) {
            case Long: {
                return (T)(cell != null && cell.length() > 0 ? Long.valueOf(cell) : Long.valueOf(-1L));
            }
        }
        return (T)cell;
    }

    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    public void calc(CsvFormula csvFormula) {
        csvFormula.calc(this);
    }

    public static List<String> parse(String line) {
        if (line == null || line.length() == 0) {
            return null;
        }
        int START = 2;
        int TERM = 3;
        int QUOTED_TERM = 4;
        int start_ESCAPEDDOUBLEQUOTE = 5;
        int state = 2;
        int length = line.length();
        ArrayList<String> tokens = new ArrayList<String>(10);
        StringBuilder buffer = new StringBuilder();
        try {
            block8: for (int i = 0; i < length; ++i) {
                char currentChar = line.charAt(i);
                switch (state) {
                    case 2: {
                        if (Character.isWhitespace(currentChar)) continue block8;
                        if (currentChar == '\"') {
                            state = 4;
                            continue block8;
                        }
                        if (currentChar == ',') continue block8;
                        state = 3;
                        buffer.append(currentChar);
                        continue block8;
                    }
                    case 4: {
                        if (currentChar != '\"') {
                            buffer.append(currentChar);
                            continue block8;
                        }
                        if (line.length() > i + 1 && line.charAt(i + 1) != '\"') {
                            state = 2;
                            tokens.add(buffer.toString());
                            buffer.setLength(0);
                            continue block8;
                        }
                        if (line.length() <= i + 1 || line.charAt(i + 1) != '\"') continue block8;
                        state = 5;
                        continue block8;
                    }
                    case 5: {
                        buffer.append(currentChar);
                        state = 4;
                        continue block8;
                    }
                    case 3: {
                        if (currentChar == ',') {
                            state = 2;
                            if (buffer.length() <= 0) continue block8;
                            tokens.add(buffer.toString());
                            buffer.setLength(0);
                            continue block8;
                        }
                        if (currentChar == '\"' && line.charAt(i + 1) == '\"') {
                            state = 5;
                            continue block8;
                        }
                        buffer.append(line.charAt(i));
                        continue block8;
                    }
                    default: {
                        throw new RuntimeException("Unknown parse state:" + (short)state);
                    }
                }
            }
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new FormatException("ERROR:" + e + " line:" + line);
        }
        if (buffer.length() > 0) {
            tokens.add(buffer.toString());
        }
        tokens.trimToSize();
        if (tokens.isEmpty()) {
            return null;
        }
        return tokens;
    }

    public List<String> row(int rowNumber) {
        List<String> row = this.data.get(rowNumber);
        if (row == null) {
            return null;
        }
        return new ArrayList<String>(row);
    }

    public void sortRowsForIndexByType(int index, DataType dataType) {
        Comparator comparator = null;
        switch (dataType) {
            case Long: {
                comparator = (list1, list2) -> Long.valueOf((String)list1.get(0)).compareTo(Long.valueOf((String)list2.get(0)));
                break;
            }
            default: {
                comparator = (list1, list2) -> ((String)list1.get(0)).compareTo((String)list2.get(0));
            }
        }
        this.sortRows(comparator);
    }

    public void sortRows(Comparator<List<String>> comparator) {
        if (this.data.isEmpty()) {
            return;
        }
        Collections.sort(this.data, comparator);
    }

    public int size() {
        return this.data.size();
    }

    public static enum DataType {
        String,
        Long;

    }
}

