/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.io.csv;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import nyla.solutions.core.io.IO;
import nyla.solutions.core.io.csv.CsvOrderByColComparator;
import nyla.solutions.core.io.csv.CsvReader;
import nyla.solutions.core.io.csv.CsvWriter;
import nyla.solutions.core.util.Organizer;

public class CsvSelectBuilder {
    private final CsvReader csvReader;
    private int orderByFieldCol;
    private int groupByFieldCol;
    private TreeSet<List<String>> orderByList;
    private Map<String, TreeSet<List<String>>> groupByMap;

    public CsvSelectBuilder(CsvReader csvReader) {
        this.csvReader = csvReader;
    }

    public CsvSelectBuilder orderBy(int csvColHeader) {
        this.orderByFieldCol = csvColHeader;
        this.orderByList = this.constructOrderByList();
        this.orderByList.addAll(this.csvReader.getData());
        return this;
    }

    private TreeSet<List<String>> constructOrderByList() {
        return new TreeSet<List<String>>(new CsvOrderByColComparator(this.orderByFieldCol));
    }

    public CsvSelectBuilder groupBy(int csvColHeader) {
        this.groupByFieldCol = csvColHeader;
        if (this.groupByMap == null) {
            this.groupByMap = new HashMap<String, TreeSet<List<String>>>();
        }
        this.orderByList.forEach(list -> {
            String groupByValue = (String)Organizer.organizeList(list).getByIndex(this.groupByFieldCol);
            TreeSet<List<String>> groupList = this.groupByMap.get(groupByValue);
            if (groupList == null) {
                groupList = this.constructOrderByList();
            }
            groupList.add((List<String>)list);
            this.groupByMap.put(groupByValue, groupList);
        });
        return this;
    }

    public Collection<Collection<List<String>>> build() {
        if (this.groupByMap == null) {
            if (this.orderByList == null || this.orderByList.isEmpty()) {
                return this.csvReader.getData();
            }
            return Collections.singletonList(this.orderByList);
        }
        return this.groupByMap.values();
    }

    public List<String> buildCsvText() {
        Collection<Collection<List<String>>> aggregatedOutput = this.build();
        ArrayList<String> returnList = new ArrayList<String>();
        for (Collection<List<String>> set : aggregatedOutput) {
            StringBuilder csvOutput = new StringBuilder();
            set.forEach(line -> csvOutput.append(CsvWriter.toCSV(line.toArray())).append(IO.newline()));
            returnList.add(csvOutput.toString());
        }
        return returnList;
    }
}

