/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.io.csv.supplier;

import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import nyla.solutions.core.io.csv.CsvReader;
import nyla.solutions.core.patterns.conversion.Converter;

public class CsvConverterSupplier<T>
implements Supplier<T> {
    private final Iterator<List<String>> reader;
    private final Converter<List<String>, T> converter;
    private int skipCnt = 0;
    private boolean notStarted = true;

    public CsvConverterSupplier(Iterator<List<String>> reader, Converter<List<String>, T> converter) {
        this.reader = reader;
        this.converter = converter;
    }

    public CsvConverterSupplier(CsvReader reader, Converter<List<String>, T> converter) {
        this(reader.iterator(), converter);
    }

    @Override
    public T get() {
        this.skipFirstLines();
        if (!this.reader.hasNext()) {
            return null;
        }
        return this.converter.convert(this.reader.next());
    }

    private void skipFirstLines() {
        if (this.notStarted && this.skipCnt > 0) {
            for (int i = 0; i < this.skipCnt; ++i) {
                if (!this.reader.hasNext()) continue;
                this.reader.next();
            }
        }
        this.notStarted = false;
    }

    public void skipLines(int skipCount) {
        this.skipCnt = skipCount;
    }
}

