/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.io.csv.transformer;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nyla.solutions.core.io.csv.CsvReader;
import nyla.solutions.core.patterns.conversion.Converter;

public class CsvToMapConverter
implements Converter<String, Map<?, ?>> {
    private final String[] headers;

    public CsvToMapConverter(String ... headers) {
        this.headers = headers;
    }

    @Override
    public Map<?, ?> convert(String csv) {
        List<String> list = CsvReader.parse(csv);
        if (list == null || list.isEmpty()) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>(this.headers.length);
        int listSize = list.size();
        for (int i = 0; i < this.headers.length; ++i) {
            map.put(this.headers[i], i < listSize ? list.get(i) : null);
        }
        return map;
    }
}

