/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.net.http;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import nyla.solutions.core.io.IO;
import nyla.solutions.core.net.http.HttpResponse;
import nyla.solutions.core.util.Text;

public class Http {
    public static final String POST_METHOD = "POST";
    public static final String GET_METHOD = "GET";
    public static final String DELETE_METHOD = "DELETE";
    private static final String PUT_METHOD = "PUT";
    private String contentType = "text/plain";
    private String user;
    private char[] password;
    private int readTimeoutSecs = 180;
    private int connectTimeoutSecs = 180;
    private Map<String, String> headers = new HashMap<String, String>();

    public HttpResponse put(URL url, String body) throws IOException {
        HttpURLConnection urlConn = this.constructRequest(PUT_METHOD, url, body);
        return this.readResponse(urlConn);
    }

    public HttpResponse post(URL url, String body) throws IOException {
        HttpURLConnection urlConn = this.constructRequest(POST_METHOD, url, body);
        return this.readResponse(urlConn);
    }

    private HttpURLConnection constructRequest(String method, URL url, String body) throws IOException {
        HttpURLConnection urlConn = (HttpURLConnection)url.openConnection();
        urlConn.setReadTimeout(this.readTimeoutSecs * 1000);
        urlConn.setConnectTimeout(this.connectTimeoutSecs * 1000);
        urlConn.setDoInput(true);
        urlConn.setDoOutput(true);
        urlConn.setUseCaches(false);
        urlConn.setRequestMethod(method);
        urlConn.setRequestProperty("Content-Type", this.contentType);
        try (DataOutputStream printout = new DataOutputStream(urlConn.getOutputStream());){
            printout.write(body.getBytes(IO.CHARSET));
            printout.flush();
        }
        return urlConn;
    }

    public HttpResponse delete(URL url) throws IOException {
        return this.readResponse(DELETE_METHOD, url);
    }

    public HttpResponse get(URL url) throws IOException {
        return this.readResponse(GET_METHOD, url);
    }

    public BufferedReader getWithReader(URL url) throws IOException {
        HttpURLConnection urlConn = (HttpURLConnection)url.openConnection();
        urlConn.setRequestMethod(GET_METHOD);
        this.constructHeaders(urlConn);
        this.constructCredentials(urlConn);
        return new BufferedReader(new InputStreamReader(urlConn.getInputStream()));
    }

    private HttpResponse readResponse(String method, URL url) throws IOException {
        return this.readResponse(method, (HttpURLConnection)url.openConnection());
    }

    private HttpResponse readResponse(String method, HttpURLConnection urlConn) throws IOException {
        urlConn.setRequestMethod(method);
        this.constructHeaders(urlConn);
        return this.readResponse(urlConn);
    }

    private void constructHeaders(HttpURLConnection urlConn) {
        for (Map.Entry<String, String> entry : this.headers.entrySet()) {
            urlConn.setRequestProperty(entry.getKey(), entry.getValue());
        }
    }

    private HttpResponse readResponse(HttpURLConnection urlConn) throws IOException {
        String body;
        int status;
        try (BufferedReader in = this.readBufferedReader(urlConn);){
            status = urlConn.getResponseCode();
            body = IO.readText(in);
        }
        return new HttpResponse(status, body);
    }

    private BufferedReader readBufferedReader(HttpURLConnection urlConn) throws IOException {
        this.constructCredentials(urlConn);
        return new BufferedReader(new InputStreamReader(urlConn.getInputStream()));
    }

    private void constructCredentials(HttpURLConnection urlConn) {
        if (this.user != null && this.user.length() > 0) {
            urlConn.setRequestProperty("Authorization", "Basic " + Text.encodeBase64(this.user + ":" + this.password));
        }
    }

    public void setHeader(String name, String value) {
        this.headers.put(name, value);
    }

    public String getHeader(String name) {
        return this.headers.get(name);
    }
}

