/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.operations;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import nyla.solutions.core.io.IO;

public class GeneratorRunScript {
    public static final String CLASSPATH_PROP = "java.class.path";
    private static int limitPerPath = 100;

    public static final void main(String[] args) {
        if (args.length == 0) {
            throw new IllegalArgumentException("outputFile required");
        }
        File file = new File(args[0]);
        try {
            FileOutputStream os = new FileOutputStream(file);
            PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)os, IO.CHARSET));
            GeneratorRunScript.writeScript(writer);
            System.out.println("See file:" + file.getAbsolutePath());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static final void writeScript(PrintStream ps) throws IOException {
        PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)System.out, IO.CHARSET));
        GeneratorRunScript.writeScript(writer);
    }

    public static final void writeScript(Writer writer) throws IOException {
        String newline = IO.newline();
        boolean isWindows = System.getProperty("os.name").startsWith("Windows");
        String variablePrefix = "$C";
        Object variableSuffix = File.pathSeparator;
        if (isWindows) {
            variablePrefix = "%C";
            variableSuffix = "%" + File.pathSeparator;
        }
        String setSyntax = isWindows ? "@set " : "export ";
        String classpath = System.getProperty(CLASSPATH_PROP);
        String cpath = null;
        HashMap<String, HashSet> map = new HashMap<String, HashSet>();
        String folderPath = null;
        HashSet folderPathClassPaths = null;
        StringTokenizer tok = new StringTokenizer(classpath, File.pathSeparator);
        while (tok.hasMoreTokens()) {
            cpath = tok.nextToken();
            folderPath = IO.parseFolderPath(cpath);
            folderPathClassPaths = (HashSet)map.get(folderPath);
            if (folderPathClassPaths == null) {
                folderPathClassPaths = new HashSet();
            }
            folderPathClassPaths.add(cpath);
            map.put(folderPath, folderPathClassPaths);
        }
        int cnt = 0;
        for (Map.Entry entry : map.entrySet()) {
            folderPath = (String)entry.getKey();
            folderPathClassPaths = (HashSet)entry.getValue();
            writer.write(IO.newline());
            writer.write(setSyntax);
            writer.write(" C" + cnt + "=");
            int printedCnt = 0;
            String line = null;
            Iterator pathI = folderPathClassPaths.iterator();
            while (pathI.hasNext()) {
                if (printedCnt > limitPerPath) {
                    writer.write(newline);
                    writer.write(setSyntax + " C" + ++cnt + "=");
                    printedCnt = 0;
                }
                line = pathI.next().toString();
                writer.write(line);
                printedCnt += line.length();
                writer.write(File.pathSeparator);
            }
            writer.write(newline);
            writer.write(newline);
            writer.flush();
        }
        writer.write(setSyntax);
        writer.write(" CLASSPATH=");
        for (int i = 0; i < cnt; ++i) {
            writer.write(variablePrefix + i);
            writer.write((String)variableSuffix);
        }
        writer.write(newline);
        writer.write(newline);
        writer.write("java <CLASS> <ARG>");
        writer.flush();
        writer.write(newline);
        writer.write("java  junit.textui.TestRunner <CLASS> <ARG>");
        writer.write(newline);
        writer.flush();
    }
}

