/*
 * Decompiled with CFR 0.152.
 */
package nyla.solutions.core.operations.performance;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public class BenchMarker {
    private final int threadCount;
    private final long threadSleepMs;
    private final int rampUPSeconds;
    private final Long loopCount;
    private final Long threadLifeTimeSeconds;
    private ExecutorService executorService;

    private BenchMarker(int threadCount, long threadSleepMs, int rampUPSeconds, Long loopCount, Long threadLifeTimeSeconds) {
        this.threadCount = threadCount;
        this.threadSleepMs = threadSleepMs;
        this.executorService = Executors.newFixedThreadPool(threadCount);
        this.rampUPSeconds = rampUPSeconds;
        this.loopCount = loopCount;
        this.threadLifeTimeSeconds = threadLifeTimeSeconds;
    }

    public static BenchMarkerBuilder builder() {
        return new BenchMarkerBuilder();
    }

    protected void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public void measure(Runnable runnable, Consumer<? extends Number> ... reporters) throws InterruptedException {
        for (int i = 0; i < this.threadCount; ++i) {
            this.executorService.execute(() -> {
                try {
                    this.executeBenchMark(runnable, reporters);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            });
            if (this.rampUPSeconds <= 0) continue;
            Thread.sleep(this.rampUPSeconds * 1000);
        }
        if (this.threadLifeTimeSeconds != null) {
            this.executorService.shutdown();
            this.executorService.awaitTermination(this.threadLifeTimeSeconds, TimeUnit.SECONDS);
        }
    }

    protected void executeBenchMark(Runnable runnable, Consumer<? extends Number> ... reporters) throws InterruptedException {
        int loopIndex = 0;
        while ((long)loopIndex < this.loopCount) {
            long start = System.nanoTime();
            runnable.run();
            long end = System.nanoTime();
            if (reporters != null) {
                for (Consumer<? extends Number> reporter : reporters) {
                    long out = end - start;
                    reporter.accept((Number)out);
                }
            }
            Thread.sleep(this.threadSleepMs);
            ++loopIndex;
        }
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    public int getRampUPSeconds() {
        return this.rampUPSeconds;
    }

    public Long getLoopCount() {
        return this.loopCount;
    }

    public Long getThreadLifeTimeSeconds() {
        return this.threadLifeTimeSeconds;
    }

    public long getThreadSleepMs() {
        return this.threadSleepMs;
    }

    public static class BenchMarkerBuilder {
        private int threadCount;
        private long threadSleepMs;
        private int rampUPSeconds;
        private Long loopCount;
        private Long threadLifeTimeSeconds;

        public BenchMarkerBuilder threadCount(int threadCount) {
            this.threadCount = threadCount;
            return this;
        }

        public BenchMarkerBuilder rampUPSeconds(int rampUPSeconds) {
            this.rampUPSeconds = rampUPSeconds;
            return this;
        }

        public BenchMarkerBuilder loopCount(Long loopCount) {
            this.loopCount = loopCount;
            return this;
        }

        public BenchMarkerBuilder threadLifeTimeSeconds(Long threadLifeTimeSeconds) {
            this.threadLifeTimeSeconds = threadLifeTimeSeconds;
            return this;
        }

        public BenchMarkerBuilder threadSleepMs(long threadSleepMs) {
            this.threadSleepMs = threadSleepMs;
            return this;
        }

        public BenchMarker build() {
            return new BenchMarker(this.threadCount, this.threadSleepMs, this.rampUPSeconds, this.loopCount, this.threadLifeTimeSeconds);
        }
    }
}

